/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.bitpacking;

import hive.parquet.bytes.BytesInput;
import hive.parquet.bytes.BytesUtils;
import hive.parquet.column.Encoding;
import hive.parquet.column.values.ValuesWriter;
import hive.parquet.column.values.bitpacking.ByteBasedBitPackingEncoder;
import hive.parquet.column.values.bitpacking.Packer;
import hive.parquet.io.ParquetEncodingException;
import java.io.IOException;

public class ByteBitPackingValuesWriter
extends ValuesWriter {
    private final Packer packer;
    private final int bitWidth;
    private ByteBasedBitPackingEncoder encoder;

    public ByteBitPackingValuesWriter(int bound, Packer packer) {
        this.packer = packer;
        this.bitWidth = BytesUtils.getWidthFromMaxInt(bound);
        this.encoder = new ByteBasedBitPackingEncoder(this.bitWidth, packer);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.BIT_PACKED;
    }

    @Override
    public BytesInput getBytes() {
        try {
            return this.encoder.toBytes();
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public void reset() {
        this.encoder = new ByteBasedBitPackingEncoder(this.bitWidth, this.packer);
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.encoder.memUsageString(prefix);
    }
}

