/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.SqlSelect;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.SqlWindow;
import hive.org.apache.calcite.sql.util.SqlBasicVisitor;
import hive.org.apache.calcite.sql.validate.AggregatingScope;
import hive.org.apache.calcite.sql.validate.AggregatingSelectScope;
import hive.org.apache.calcite.sql.validate.SqlQualified;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.Stacks;
import hive.org.apache.calcite.util.Static;
import java.util.List;

class AggChecker
extends SqlBasicVisitor<Void> {
    private final List<SqlValidatorScope> scopes = Lists.newArrayList();
    private final List<SqlNode> groupExprs;
    private boolean distinct;
    private SqlValidatorImpl validator;

    AggChecker(SqlValidatorImpl validator, AggregatingScope scope, List<SqlNode> groupExprs, boolean distinct) {
        this.validator = validator;
        this.groupExprs = groupExprs;
        this.distinct = distinct;
        Stacks.push(this.scopes, scope);
    }

    boolean isGroupExpr(SqlNode expr) {
        for (SqlNode groupExpr : this.groupExprs) {
            if (!groupExpr.equalsDeep(expr, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visit(SqlIdentifier id) {
        if (this.isGroupExpr(id) || id.isStar()) {
            return null;
        }
        SqlCall call = SqlUtil.makeCall(this.validator.getOperatorTable(), id);
        if (call != null) {
            return call.accept(this);
        }
        SqlQualified fqId = Stacks.peek(this.scopes).fullyQualify(id);
        if (this.isGroupExpr(fqId.identifier)) {
            return null;
        }
        SqlNode originalExpr = this.validator.getOriginal(id);
        String exprString = originalExpr.toString();
        throw this.validator.newValidationError(originalExpr, this.distinct ? Static.RESOURCE.notSelectDistinctExpr(exprString) : Static.RESOURCE.notGroupExpr(exprString));
    }

    @Override
    public Void visit(SqlCall call) {
        SqlValidatorScope scope = Stacks.peek(this.scopes);
        if (call.getOperator().isAggregator()) {
            if (this.distinct) {
                if (scope instanceof AggregatingSelectScope) {
                    SqlNodeList selectList = ((SqlSelect)scope.getNode()).getSelectList();
                    for (SqlNode sqlNode : selectList) {
                        if (sqlNode.getKind() == SqlKind.AS) {
                            sqlNode = ((SqlCall)sqlNode).operand(0);
                        }
                        if (!this.validator.expand(sqlNode, scope).equalsDeep(call, false)) continue;
                        return null;
                    }
                }
                SqlNode originalExpr = this.validator.getOriginal(call);
                String exprString = originalExpr.toString();
                throw this.validator.newValidationError(call, Static.RESOURCE.notSelectDistinctExpr(exprString));
            }
            return null;
        }
        if (call.getKind() == SqlKind.FILTER) {
            ((SqlNode)call.operand(0)).accept(this);
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            for (SqlNode operand : ((SqlCall)call.operand(0)).getOperandList()) {
                operand.accept(this);
            }
            Object over = call.operand(1);
            if (over instanceof SqlCall) {
                ((SqlNode)over).accept(this);
            } else if (over instanceof SqlIdentifier) {
                SqlWindow window = scope.lookupWindow(((SqlIdentifier)over).getSimple());
                window.getPartitionList().accept(this);
                window.getOrderList().accept(this);
            }
        }
        if (this.isGroupExpr(call)) {
            return null;
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        SqlValidatorScope newScope = scope.getOperandScope(call);
        Stacks.push(this.scopes, newScope);
        call.getOperator().acceptCall(this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
        Stacks.pop(this.scopes, newScope);
        return null;
    }
}

