/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperandCountRange;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.type.SqlOperandCountRanges;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import hive.org.apache.calcite.util.Static;
import hive.org.apache.calcite.util.Util;

public class LiteralOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    private boolean allowNull;

    public LiteralOperandTypeChecker(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        Util.discard(iFormalOperand);
        if (SqlUtil.isNullLiteral(node, true)) {
            if (this.allowNull) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustNotBeNull(callBinding.getOperator().getName()));
            }
            return false;
        }
        if (!SqlUtil.isLiteral(node) && !SqlUtil.isLiteralChain(node)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustBeLiteral(callBinding.getOperator().getName()));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<LITERAL>";
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

