/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.org.apache.calcite.avatica.util.TimeUnit;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import hive.org.apache.calcite.rel.type.RelDataTypeSystem;
import hive.org.apache.calcite.sql.SqlDialect;
import hive.org.apache.calcite.sql.SqlIntervalQualifier;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import hive.org.apache.calcite.sql.type.AbstractSqlType;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.sql.util.SqlString;

public class IntervalSqlType
extends AbstractSqlType {
    private final RelDataTypeSystem typeSystem;
    private SqlIntervalQualifier intervalQualifier;

    public IntervalSqlType(RelDataTypeSystem typeSystem, SqlIntervalQualifier intervalQualifier, boolean isNullable) {
        super(intervalQualifier.isYearMonth() ? SqlTypeName.INTERVAL_YEAR_MONTH : SqlTypeName.INTERVAL_DAY_TIME, isNullable, null);
        this.typeSystem = typeSystem;
        this.intervalQualifier = intervalQualifier;
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("INTERVAL ");
        SqlDialect dialect = null;
        dialect = SqlDialect.DUMMY;
        SqlPrettyWriter writer = new SqlPrettyWriter(dialect);
        writer.setAlwaysUseParentheses(false);
        writer.setSelectListItemsOnSeparateLines(false);
        writer.setIndentation(0);
        this.intervalQualifier.unparse(writer, 0, 0);
        String sql = writer.toString();
        sb.append(new SqlString(dialect, sql).getSql());
    }

    @Override
    public SqlIntervalQualifier getIntervalQualifier() {
        return this.intervalQualifier;
    }

    public IntervalSqlType combine(RelDataTypeFactoryImpl typeFactory, IntervalSqlType that) {
        assert (this.intervalQualifier.isYearMonth() == that.intervalQualifier.isYearMonth());
        boolean nullable = this.isNullable || that.isNullable;
        TimeUnit thisStart = this.intervalQualifier.getStartUnit();
        TimeUnit thisEnd = this.intervalQualifier.getEndUnit();
        TimeUnit thatStart = that.intervalQualifier.getStartUnit();
        TimeUnit thatEnd = that.intervalQualifier.getEndUnit();
        assert (null != thisStart);
        assert (null != thatStart);
        int secondPrec = this.intervalQualifier.getStartPrecisionPreservingDefault();
        int fracPrec = SqlIntervalQualifier.combineFractionalSecondPrecisionPreservingDefault(this.typeSystem, this.intervalQualifier, that.intervalQualifier);
        if (thisStart.ordinal() > thatStart.ordinal()) {
            thisEnd = thisStart;
            thisStart = thatStart;
            secondPrec = that.intervalQualifier.getStartPrecisionPreservingDefault();
        } else if (thisStart.ordinal() == thatStart.ordinal()) {
            secondPrec = SqlIntervalQualifier.combineStartPrecisionPreservingDefault(typeFactory.getTypeSystem(), this.intervalQualifier, that.intervalQualifier);
        } else if (null == thisEnd || thisEnd.ordinal() < thatStart.ordinal()) {
            thisEnd = thatStart;
        }
        if (null != thatEnd && (null == thisEnd || thisEnd.ordinal() < thatEnd.ordinal())) {
            thisEnd = thatEnd;
        }
        RelDataType intervalType = typeFactory.createSqlIntervalType(new SqlIntervalQualifier(thisStart, secondPrec, thisEnd, fracPrec, SqlParserPos.ZERO));
        intervalType = typeFactory.createTypeWithNullability(intervalType, nullable);
        return (IntervalSqlType)intervalType;
    }

    @Override
    public int getPrecision() {
        return this.intervalQualifier.getStartPrecision(this.typeSystem);
    }

    @Override
    public int getScale() {
        return this.intervalQualifier.getFractionalSecondPrecision(this.typeSystem);
    }
}

