/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlCollation;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlSyntax;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlOperandTypeInference;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.util.Util;

public class SqlPostfixOperator
extends SqlOperator {
    public SqlPostfixOperator(String name, SqlKind kind, int prec, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlPostfixOperator.leftPrec(prec, true), SqlPostfixOperator.rightPrec(prec, true), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.POSTFIX;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0}";
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            RelDataType operandType = validator.getValidatedNodeType((SqlNode)call.operand(0));
            if (null == operandType) {
                throw Util.newInternal("operand's type should have been derived");
            }
            if (SqlTypeUtil.inCharFamily(operandType)) {
                SqlCollation collation = operandType.getCollation();
                assert (null != collation) : "An implicit or explicit collation should have been set";
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, type.getCharset(), new SqlCollation(collation.getCollationName(), collation.getCoercibility()));
            }
        }
        return type;
    }

    @Override
    public boolean validRexOperands(int count, boolean fail) {
        if (count != 1) {
            assert (!fail) : "wrong operand count " + count + " for " + this;
            return false;
        }
        return true;
    }
}

