/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import java.util.Calendar;

public class SqlDateLiteral
extends SqlAbstractDateTimeLiteral {
    SqlDateLiteral(Calendar d, SqlParserPos pos) {
        super(d, false, SqlTypeName.DATE, 0, "yyyy-MM-dd", pos);
    }

    SqlDateLiteral(Calendar d, String format, SqlParserPos pos) {
        super(d, false, SqlTypeName.DATE, 0, format, pos);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlDateLiteral((Calendar)this.value, pos);
    }

    @Override
    public String toString() {
        return "DATE '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        return this.getDate().toString(this.formatString);
    }

    @Override
    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(this.getTypeName());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (writer.getDialect().getDatabaseProduct()) {
            case MSSQL: {
                writer.literal("'" + this.toFormattedString() + "'");
                break;
            }
            default: {
                writer.literal(this.toString());
            }
        }
    }
}

