/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.schema.impl;

import hive.com.google.common.collect.ImmutableMultimap;
import hive.org.apache.calcite.adapter.enumerable.CallImplementor;
import hive.org.apache.calcite.adapter.enumerable.NullPolicy;
import hive.org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import hive.org.apache.calcite.adapter.enumerable.RexImpTable;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.schema.ImplementableFunction;
import hive.org.apache.calcite.schema.ScalarFunction;
import hive.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import hive.org.apache.calcite.util.Static;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ScalarFunctionImpl
extends ReflectiveFunctionBase
implements ScalarFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private ScalarFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static ImmutableMultimap<String, ScalarFunction> createAll(Class<?> clazz) {
        ImmutableMultimap.Builder<String, ScalarFunction> builder = ImmutableMultimap.builder();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isStatic(method.getModifiers()) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) continue;
            ScalarFunction function = ScalarFunctionImpl.create(method);
            builder.put(method.getName(), function);
        }
        return builder.build();
    }

    public static ScalarFunction create(Class<?> clazz, String methodName) {
        Method method = ScalarFunctionImpl.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        return ScalarFunctionImpl.create(method);
    }

    public static ScalarFunction create(Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        CallImplementor implementor = ScalarFunctionImpl.createImplementor(method);
        return new ScalarFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.method.getReturnType());
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method), NullPolicy.NONE, false);
    }
}

