/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.rex.RexVisitor;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.rex.RexWindow;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.util.ControlFlowException;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class RexOver
extends RexCall {
    private static final Finder FINDER = new Finder();
    private final RexWindow window;

    RexOver(RelDataType type, SqlAggFunction op, List<RexNode> operands, RexWindow window) {
        super(type, op, operands);
        assert (op.isAggregator()) : "precondition: op.isAggregator()";
        assert (window != null) : "precondition: window != null";
        this.window = window;
        this.digest = this.computeDigest(true);
    }

    public SqlAggFunction getAggOperator() {
        return (SqlAggFunction)this.getOperator();
    }

    public RexWindow getWindow() {
        return this.window;
    }

    @Override
    protected String computeDigest(boolean withType) {
        return super.computeDigest(withType) + " OVER (" + this.window + ")";
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitOver(this);
    }

    public static boolean containsOver(RexNode expr) {
        try {
            expr.accept(FINDER);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(RexProgram program) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, program.getExprList(), null);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(List<RexNode> exprs, RexNode condition) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, exprs, condition);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    @Override
    public RexCall clone(RelDataType type, List<RexNode> operands) {
        throw new UnsupportedOperationException();
    }

    private static class Finder
    extends RexVisitorImpl<Void> {
        public Finder() {
            super(true);
        }

        @Override
        public Void visitOver(RexOver over) {
            throw OverFound.INSTANCE;
        }
    }

    private static class OverFound
    extends ControlFlowException {
        public static final OverFound INSTANCE = new OverFound();

        private OverFound() {
        }
    }
}

