/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.stream;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.prepare.RelOptTableImpl;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.logical.LogicalAggregate;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rel.logical.LogicalSort;
import hive.org.apache.calcite.rel.logical.LogicalTableScan;
import hive.org.apache.calcite.rel.logical.LogicalUnion;
import hive.org.apache.calcite.rel.stream.Delta;
import hive.org.apache.calcite.rel.stream.LogicalDelta;
import hive.org.apache.calcite.schema.StreamableTable;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;

public class StreamRules {
    public static final ImmutableList<RelOptRule> RULES = ImmutableList.of(new DeltaProjectTransposeRule(), new DeltaFilterTransposeRule(), new DeltaAggregateTransposeRule(), new DeltaSortTransposeRule(), new DeltaUnionTransposeRule(), new DeltaTableScanRule());

    private StreamRules() {
    }

    public static class DeltaTableScanRule
    extends RelOptRule {
        private DeltaTableScanRule() {
            super(DeltaTableScanRule.operand(Delta.class, DeltaTableScanRule.operand(TableScan.class, DeltaTableScanRule.none()), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            RelOptCluster cluster = delta.getCluster();
            RelOptTable relOptTable = scan.getTable();
            StreamableTable streamableTable = relOptTable.unwrap(StreamableTable.class);
            if (streamableTable != null) {
                Table table1 = streamableTable.stream();
                RelOptTableImpl relOptTable2 = RelOptTableImpl.create(relOptTable.getRelOptSchema(), relOptTable.getRowType(), table1);
                LogicalTableScan newScan = LogicalTableScan.create(cluster, relOptTable2);
                call.transformTo(newScan);
            }
        }
    }

    public static class DeltaUnionTransposeRule
    extends RelOptRule {
        private DeltaUnionTransposeRule() {
            super(DeltaUnionTransposeRule.operand(Delta.class, DeltaUnionTransposeRule.operand(Union.class, DeltaUnionTransposeRule.any()), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Union union = (Union)call.rel(1);
            ArrayList<RelNode> newInputs = Lists.newArrayList();
            for (RelNode input : union.getInputs()) {
                LogicalDelta newDelta = LogicalDelta.create(input);
                newInputs.add(newDelta);
            }
            LogicalUnion newUnion = LogicalUnion.create(newInputs, union.all);
            call.transformTo(newUnion);
        }
    }

    public static class DeltaSortTransposeRule
    extends RelOptRule {
        private DeltaSortTransposeRule() {
            super(DeltaSortTransposeRule.operand(Delta.class, DeltaSortTransposeRule.operand(Sort.class, DeltaSortTransposeRule.any()), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Sort sort = (Sort)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(sort.getInput());
            LogicalSort newSort = LogicalSort.create(newDelta, sort.collation, sort.offset, sort.fetch);
            call.transformTo(newSort);
        }
    }

    public static class DeltaAggregateTransposeRule
    extends RelOptRule {
        private DeltaAggregateTransposeRule() {
            super(DeltaAggregateTransposeRule.operand(Delta.class, DeltaAggregateTransposeRule.operand(Aggregate.class, DeltaAggregateTransposeRule.any()), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Aggregate aggregate = (Aggregate)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(aggregate.getInput());
            LogicalAggregate newAggregate = LogicalAggregate.create(newDelta, aggregate.indicator, aggregate.getGroupSet(), aggregate.groupSets, aggregate.getAggCallList());
            call.transformTo(newAggregate);
        }
    }

    public static class DeltaFilterTransposeRule
    extends RelOptRule {
        private DeltaFilterTransposeRule() {
            super(DeltaFilterTransposeRule.operand(Delta.class, DeltaFilterTransposeRule.operand(Filter.class, DeltaFilterTransposeRule.any()), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Filter filter = (Filter)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(filter.getInput());
            LogicalFilter newFilter = LogicalFilter.create(newDelta, filter.getCondition());
            call.transformTo(newFilter);
        }
    }

    public static class DeltaProjectTransposeRule
    extends RelOptRule {
        private DeltaProjectTransposeRule() {
            super(DeltaProjectTransposeRule.operand(Delta.class, DeltaProjectTransposeRule.operand(Project.class, DeltaProjectTransposeRule.any()), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Project project = (Project)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(project.getInput());
            LogicalProject newProject = LogicalProject.create((RelNode)newDelta, project.getProjects(), project.getRowType().getFieldNames());
            call.transformTo(newProject);
        }
    }
}

