/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableMap;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.util.mapping.Mappings;

public class SortProjectTransposeRule
extends RelOptRule {
    public static final SortProjectTransposeRule INSTANCE = new SortProjectTransposeRule();

    private SortProjectTransposeRule() {
        super(SortProjectTransposeRule.operand(Sort.class, SortProjectTransposeRule.operand(LogicalProject.class, SortProjectTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        if (sort.getConvention() != project.getConvention()) {
            return;
        }
        Mappings.TargetMapping map = RelOptUtil.permutation(project.getProjects(), project.getInput().getRowType());
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            if (map.getTargetOpt(fc.getFieldIndex()) >= 0) continue;
            return;
        }
        RelCollation newCollation = cluster.traitSet().canonize(RexUtil.apply(map, sort.getCollation()));
        Sort newSort = sort.copy(sort.getTraitSet().replace(newCollation), project.getInput(), newCollation, sort.offset, sort.fetch);
        RelNode newProject = project.copy(sort.getTraitSet(), ImmutableList.of(newSort));
        ImmutableMap<RelNode, RelNode> equiv = sort.offset == null && sort.fetch == null && cluster.getPlanner().getRelTraitDefs().contains(RelCollationTraitDef.INSTANCE) ? ImmutableMap.of(newSort, project.getInput()) : ImmutableMap.of();
        call.transformTo(newProject, equiv);
    }
}

