/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.rex.RexProgramBuilder;
import hive.org.apache.calcite.sql.validate.SqlValidatorUtil;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SemiJoinProjectTransposeRule
extends RelOptRule {
    public static final SemiJoinProjectTransposeRule INSTANCE = new SemiJoinProjectTransposeRule();

    private SemiJoinProjectTransposeRule() {
        super(SemiJoinProjectTransposeRule.operand(SemiJoin.class, SemiJoinProjectTransposeRule.some(SemiJoinProjectTransposeRule.operand(LogicalProject.class, SemiJoinProjectTransposeRule.any()), new RelOptRuleOperand[0])));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SemiJoin semiJoin = (SemiJoin)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        ArrayList<Integer> newLeftKeys = new ArrayList<Integer>();
        ImmutableIntList leftKeys = semiJoin.getLeftKeys();
        List<RexNode> projExprs = project.getProjects();
        Iterator i$ = leftKeys.iterator();
        while (i$.hasNext()) {
            int leftKey = (Integer)i$.next();
            RexInputRef inputRef = (RexInputRef)projExprs.get(leftKey);
            newLeftKeys.add(inputRef.getIndex());
        }
        RexNode newCondition = this.adjustCondition(project, semiJoin);
        SemiJoin newSemiJoin = SemiJoin.create(project.getInput(), semiJoin.getRight(), newCondition, ImmutableIntList.copyOf(newLeftKeys), semiJoin.getRightKeys());
        RelNode newProject = RelOptUtil.createProject((RelNode)newSemiJoin, projExprs, project.getRowType().getFieldNames());
        call.transformTo(newProject);
    }

    private RexNode adjustCondition(LogicalProject project, SemiJoin semiJoin) {
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelNode rightChild = semiJoin.getRight();
        RelDataType bottomInputRowType = SqlValidatorUtil.deriveJoinRowType(project.getInput().getRowType(), rightChild.getRowType(), JoinRelType.INNER, typeFactory, null, semiJoin.getSystemFieldList());
        RexProgramBuilder bottomProgramBuilder = new RexProgramBuilder(bottomInputRowType, rexBuilder);
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            bottomProgramBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        int nLeftFields = project.getInput().getRowType().getFieldCount();
        List<RelDataTypeField> rightFields = rightChild.getRowType().getFieldList();
        int nRightFields = rightFields.size();
        for (int i = 0; i < nRightFields; ++i) {
            RelDataTypeField field = rightFields.get(i);
            RexInputRef inputRef = rexBuilder.makeInputRef(field.getType(), i + nLeftFields);
            bottomProgramBuilder.addProject(inputRef, field.getName());
        }
        RexProgram bottomProgram = bottomProgramBuilder.getProgram();
        RelDataType topInputRowType = SqlValidatorUtil.deriveJoinRowType(project.getRowType(), rightChild.getRowType(), JoinRelType.INNER, typeFactory, null, semiJoin.getSystemFieldList());
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(topInputRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(semiJoin.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        return mergedProgram.expandLocalRef(mergedProgram.getCondition());
    }
}

