/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.base.Predicate;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import java.util.List;

public class ProjectRemoveRule
extends RelOptRule {
    private static final Predicate<Project> PREDICATE = new Predicate<Project>(){

        @Override
        public boolean apply(Project input) {
            return ProjectRemoveRule.isTrivial(input);
        }
    };
    public static final ProjectRemoveRule INSTANCE = new ProjectRemoveRule();

    private ProjectRemoveRule() {
        super(ProjectRemoveRule.operand(Project.class, null, PREDICATE, ProjectRemoveRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        assert (ProjectRemoveRule.isTrivial(project));
        RelNode stripped = project.getInput();
        if (stripped instanceof Project) {
            Project childProject = (Project)stripped;
            stripped = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), project.getRowType());
        }
        RelNode child = call.getPlanner().register(stripped, project);
        call.transformTo(child);
    }

    public static RelNode strip(Project project) {
        return ProjectRemoveRule.isTrivial(project) ? project.getInput() : project;
    }

    public static boolean isTrivial(Project project) {
        return ProjectRemoveRule.isIdentity(project.getProjects(), project.getInput().getRowType());
    }

    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType childRowType) {
        return childRowType.getFieldCount() == exps.size() && RexUtil.containIdentity(exps, childRowType, false);
    }
}

