/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.rules.ProjectRemoveRule;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.Permutation;
import java.util.List;

public class ProjectMergeRule
extends RelOptRule {
    public static final ProjectMergeRule INSTANCE = new ProjectMergeRule(true, RelFactories.DEFAULT_PROJECT_FACTORY);
    private final boolean force;
    private final RelFactories.ProjectFactory projectFactory;

    public ProjectMergeRule(boolean force, RelFactories.ProjectFactory projectFactory) {
        super(ProjectMergeRule.operand(Project.class, ProjectMergeRule.operand(Project.class, ProjectMergeRule.any()), new RelOptRuleOperand[0]), "ProjectMergeRule" + (force ? ":force_mode" : ""));
        this.force = force;
        this.projectFactory = projectFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                call.transformTo(RelOptUtil.projectMapping(bottomProject.getInput(), product.inverse(), topProject.getRowType().getFieldNames(), this.projectFactory));
                return;
            }
        }
        if (!this.force && ProjectRemoveRule.isIdentity(topProject.getProjects(), topProject.getInput().getRowType())) {
            return;
        }
        List<RexNode> newProjects = RelOptUtil.pushPastProject(topProject.getProjects(), bottomProject);
        if (ProjectRemoveRule.isIdentity(newProjects, (input = bottomProject.getInput()).getRowType()) && (this.force || input.getRowType().getFieldNames().equals(topProject.getRowType().getFieldNames()))) {
            call.transformTo(input);
            return;
        }
        RelNode newProjectRel = this.projectFactory.createProject(bottomProject.getInput(), newProjects, topProject.getRowType().getFieldNames());
        call.transformTo(newProjectRel);
    }
}

