/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptPredicateList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexUtil;

public class JoinPushTransitivePredicatesRule
extends RelOptRule {
    private final RelFactories.FilterFactory filterFactory;
    public static final JoinPushTransitivePredicatesRule INSTANCE = new JoinPushTransitivePredicatesRule(Join.class, RelFactories.DEFAULT_FILTER_FACTORY);

    public JoinPushTransitivePredicatesRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(JoinPushTransitivePredicatesRule.operand(clazz, JoinPushTransitivePredicatesRule.any()));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        Join join = (Join)call.rel(0);
        RelOptPredicateList preds = RelMetadataQuery.getPulledUpPredicates(join);
        if (preds.leftInferredPredicates.isEmpty() && preds.rightInferredPredicates.isEmpty()) {
            return;
        }
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode lChild = join.getLeft();
        RelNode rChild = join.getRight();
        if (preds.leftInferredPredicates.size() > 0) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, RexUtil.composeConjunction(rB, preds.leftInferredPredicates, false));
            call.getPlanner().onCopy(curr, lChild);
        }
        if (preds.rightInferredPredicates.size() > 0) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, RexUtil.composeConjunction(rB, preds.rightInferredPredicates, false));
            call.getPlanner().onCopy(curr, rChild);
        }
        Join newRel = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newRel);
        call.transformTo(newRel);
    }
}

