/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.plan.Contexts;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.tools.RelBuilder;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.List;

public class FilterAggregateTransposeRule
extends RelOptRule {
    public static final FilterAggregateTransposeRule INSTANCE = new FilterAggregateTransposeRule(Filter.class, RelFactories.DEFAULT_PROTO, Aggregate.class);
    private final RelBuilder.ProtoRelBuilder protoBuilder;

    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelBuilder.ProtoRelBuilder protoBuilder, Class<? extends Aggregate> aggregateClass) {
        super(FilterAggregateTransposeRule.operand(filterClass, FilterAggregateTransposeRule.operand(aggregateClass, FilterAggregateTransposeRule.any()), new RelOptRuleOperand[0]));
        this.protoBuilder = protoBuilder;
    }

    @Deprecated
    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Aggregate> aggregateClass) {
        this(filterClass, RelBuilder.proto(Contexts.of((Object)filterFactory)), aggregateClass);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        Aggregate aggRel = (Aggregate)call.rel(1);
        List<RexNode> conditions = RelOptUtil.conjunctions(filterRel.getCondition());
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = aggRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList<RexNode> pushedConditions = Lists.newArrayList();
        ArrayList<RexNode> remainingConditions = Lists.newArrayList();
        for (RexNode condition : conditions) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(condition);
            if (this.canPush(aggRel, rCols)) {
                pushedConditions.add(condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, aggRel.getInput(0).getRowType().getFieldList(), adjustments)));
                continue;
            }
            remainingConditions.add(condition);
        }
        RelBuilder builder = call.builder(this.protoBuilder);
        RelNode rel = builder.push(aggRel.getInput()).filter(pushedConditions).build();
        if (rel == aggRel.getInput(0)) {
            return;
        }
        rel = aggRel.copy(aggRel.getTraitSet(), ImmutableList.of(rel));
        rel = builder.push(rel).filter(remainingConditions).build();
        call.transformTo(rel);
    }

    private boolean canPush(Aggregate aggregate, ImmutableBitSet rCols) {
        ImmutableBitSet groupKeys = ImmutableBitSet.range(0, aggregate.getGroupSet().cardinality());
        if (!groupKeys.contains(rCols)) {
            return false;
        }
        if (aggregate.indicator) {
            for (ImmutableBitSet groupingSet : aggregate.getGroupSets()) {
                if (groupingSet.contains(rCols)) continue;
                return false;
            }
        }
        return true;
    }
}

