/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.util.BuiltInMethod;

public class RelMdMemory {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Object)new RelMdMemory(), BuiltInMethod.MEMORY.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE_SPLIT.method);

    protected RelMdMemory() {
    }

    public Double memory(RelNode rel) {
        return null;
    }

    public Double cumulativeMemoryWithinPhase(RelNode rel) {
        Double nullable = RelMetadataQuery.memory(rel);
        if (nullable == null) {
            return null;
        }
        Boolean isPhaseTransition = RelMetadataQuery.isPhaseTransition(rel);
        if (isPhaseTransition == null) {
            return null;
        }
        double d = nullable;
        if (!isPhaseTransition.booleanValue()) {
            for (RelNode input : rel.getInputs()) {
                nullable = RelMetadataQuery.cumulativeMemoryWithinPhase(input);
                if (nullable == null) {
                    return null;
                }
                d += nullable.doubleValue();
            }
        }
        return d;
    }

    public Double cumulativeMemoryWithinPhaseSplit(RelNode rel) {
        Double memoryWithinPhase = RelMetadataQuery.cumulativeMemoryWithinPhase(rel);
        Integer splitCount = RelMetadataQuery.splitCount(rel);
        if (memoryWithinPhase == null || splitCount == null) {
            return null;
        }
        return memoryWithinPhase / (double)splitCount.intValue();
    }
}

