/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexChecker;
import hive.org.apache.calcite.rex.RexFieldAccess;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLocalRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexShuttle;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.sql.SqlExplainLevel;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Permutation;
import hive.org.apache.calcite.util.Util;
import hive.org.apache.calcite.util.mapping.Mapping;
import hive.org.apache.calcite.util.mapping.MappingType;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public abstract class Project
extends SingleRel {
    protected final ImmutableList<RexNode> exps;

    protected Project(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, input);
        assert (rowType != null);
        this.exps = ImmutableList.copyOf(projects);
        this.rowType = rowType;
        assert (this.isValid(true));
    }

    @Deprecated
    protected Project(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, input, projects, rowType);
        Util.discard(flags);
    }

    protected Project(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getExpressionList("exprs"), input.getRowType("exprs", "fields"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Project.sole(inputs), this.exps, this.rowType);
    }

    public abstract Project copy(RelTraitSet var1, RelNode var2, List<RexNode> var3, RelDataType var4);

    @Deprecated
    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
        Util.discard(flags);
        return this.copy(traitSet, input, projects, rowType);
    }

    @Deprecated
    public boolean isBoxed() {
        return true;
    }

    @Override
    public List<RexNode> getChildExps() {
        return this.exps;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        List<RexNode> exps = shuttle.apply(this.exps);
        if (this.exps == exps) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), exps, this.rowType);
    }

    public List<RexNode> getProjects() {
        return this.exps;
    }

    public final List<Pair<RexNode, String>> getNamedProjects() {
        return Pair.zip(this.getProjects(), this.getRowType().getFieldNames());
    }

    @Deprecated
    public int getFlags() {
        return 1;
    }

    @Override
    public boolean isValid(boolean fail) {
        if (!super.isValid(fail)) {
            assert (!fail);
            return false;
        }
        if (!RexUtil.compatibleTypes(this.exps, this.getRowType(), true)) {
            assert (!fail);
            return false;
        }
        RexChecker checker = new RexChecker(this.getInput().getRowType(), fail);
        for (RexNode exp : this.exps) {
            exp.accept(checker);
        }
        if (checker.getFailureCount() > 0) {
            assert (!fail);
            return false;
        }
        if (!Util.isDistinct(this.rowType.getFieldNames())) {
            assert (!fail) : this.rowType;
            return false;
        }
        return true;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows = RelMetadataQuery.getRowCount(this.getInput());
        double dCpu = dRows * (double)this.exps.size();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("fields", this.rowType.getFieldNames());
            pw.item("exprs", this.exps);
        } else {
            for (Ord field : Ord.zip(this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, this.exps.get(field.i));
            }
        }
        if (pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES) {
            // empty if block
        }
        return pw;
    }

    public Mappings.TargetMapping getMapping() {
        return Project.getMapping(this.getInput().getRowType().getFieldCount(), this.exps);
    }

    public static Mappings.TargetMapping getMapping(int inputFieldCount, List<? extends RexNode> projects) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, inputFieldCount, projects.size());
        for (Ord exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) {
                return null;
            }
            mapping.set(((RexInputRef)exp.e).getIndex(), exp.i);
        }
        return mapping;
    }

    public static Mappings.TargetMapping getPartialMapping(int inputFieldCount, List<? extends RexNode> projects) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_FUNCTION, inputFieldCount, projects.size());
        for (Ord exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) continue;
            mapping.set(((RexInputRef)exp.e).getIndex(), exp.i);
        }
        return mapping;
    }

    public Permutation getPermutation() {
        return Project.getPermutation(this.getInput().getRowType().getFieldCount(), this.exps);
    }

    public static Permutation getPermutation(int inputFieldCount, List<? extends RexNode> projects) {
        int fieldCount = projects.size();
        if (fieldCount != inputFieldCount) {
            return null;
        }
        Permutation permutation = new Permutation(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            RexNode exp = projects.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            permutation.set(i, ((RexInputRef)exp).getIndex());
        }
        return permutation;
    }

    public boolean isMapping() {
        for (RexNode exp : this.exps) {
            if (exp instanceof RexInputRef) continue;
            return false;
        }
        return true;
    }

    private static class Checker
    extends RexVisitorImpl<Boolean> {
        private final boolean fail;
        private final RelDataType inputRowType;
        int failCount = 0;

        private Checker(RelDataType inputRowType, boolean fail) {
            super(true);
            this.fail = fail;
            this.inputRowType = inputRowType;
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            List<RelDataTypeField> fields = this.inputRowType.getFieldList();
            if (index < 0 || index >= fields.size()) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            if (!RelOptUtil.eq("inputRef", inputRef.getType(), "underlying field", fields.get(index).getType(), this.fail)) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            assert (!this.fail) : "localRef invalid in project";
            ++this.failCount;
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            super.visitFieldAccess(fieldAccess);
            RelDataType refType = fieldAccess.getReferenceExpr().getType();
            assert (refType.isStruct());
            RelDataTypeField field = fieldAccess.getField();
            int index = field.getIndex();
            if (index < 0 || index > refType.getFieldList().size()) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            RelDataTypeField typeField = refType.getFieldList().get(index);
            if (!RelOptUtil.eq("type1", typeField.getType(), "type2", fieldAccess.getType(), this.fail)) {
                assert (!this.fail);
                ++this.failCount;
                return false;
            }
            return true;
        }
    }

    @Deprecated
    public static class Flags {
        public static final int ANON_FIELDS = 2;
        public static final int BOXED = 1;
        public static final int NONE = 0;
    }
}

