/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.prepare;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.jdbc.CalciteSchemaImpl;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptSchema;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelTraitDef;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.prepare.CalciteCatalogReader;
import hive.org.apache.calcite.prepare.CalciteSqlValidator;
import hive.org.apache.calcite.prepare.Prepare;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperatorTable;
import hive.org.apache.calcite.sql.TypedSqlNode;
import hive.org.apache.calcite.sql.parser.SqlParseException;
import hive.org.apache.calcite.sql.parser.SqlParser;
import hive.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql2rel.RelDecorrelator;
import hive.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import hive.org.apache.calcite.sql2rel.SqlToRelConverter;
import hive.org.apache.calcite.tools.FrameworkConfig;
import hive.org.apache.calcite.tools.Frameworks;
import hive.org.apache.calcite.tools.Planner;
import hive.org.apache.calcite.tools.Program;
import hive.org.apache.calcite.tools.RelConversionException;
import hive.org.apache.calcite.tools.ValidationException;
import hive.org.apache.calcite.util.Util;
import java.util.Arrays;
import java.util.List;

public class PlannerImpl
implements Planner {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    private final FrameworkConfig config;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.Config parserConfig;
    private final SqlRexConvertletTable convertletTable;
    private State state;
    private boolean open;
    private SchemaPlus defaultSchema;
    private JavaTypeFactory typeFactory;
    private RelOptPlanner planner;
    private RelOptPlanner.Executor executor;
    private CalciteSqlValidator validator;
    private SqlNode validatedSqlNode;
    private RelNode rel;

    public PlannerImpl(FrameworkConfig config) {
        this.config = config;
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.executor = config.getExecutor();
        this.reset();
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    @Override
    public RelTraitSet getEmptyTraitSet() {
        return this.planner.emptyTraitSet();
    }

    @Override
    public void close() {
        this.open = false;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    @Override
    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
            }
        }
        this.ensure(State.STATE_1_RESET);
        Frameworks.withPlanner(new Frameworks.PlannerAction<Void>(){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                Util.discard(rootSchema);
                PlannerImpl.this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
                PlannerImpl.this.planner = cluster.getPlanner();
                PlannerImpl.this.planner.setExecutor(PlannerImpl.this.executor);
                return null;
            }
        }, this.config);
        this.state = State.STATE_2_READY;
        if (this.traitDefs != null) {
            this.planner.clearRelTraitDefs();
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
    }

    @Override
    public SqlNode parse(String sql) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create(sql, this.parserConfig);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    @Override
    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        CalciteCatalogReader catalogReader = this.createCatalogReader();
        ChainedSqlOperatorTable opTab = new ChainedSqlOperatorTable(Arrays.asList(this.operatorTable, catalogReader));
        this.validator = new CalciteSqlValidator(opTab, this.createCatalogReader(), this.typeFactory);
        this.validator.setIdentifierExpansion(true);
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    @Override
    public TypedSqlNode validateAndGetType(SqlNode sqlNode) throws ValidationException {
        SqlNode validatedNode = this.validate(sqlNode);
        RelDataType type = this.validator.getValidatedNodeType(validatedNode);
        return new TypedSqlNode(validatedNode, type);
    }

    @Override
    public RelNode convert(SqlNode sql) throws RelConversionException {
        this.ensure(State.STATE_4_VALIDATED);
        assert (this.validatedSqlNode != null);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(this.planner, rexBuilder);
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(false).withConvertTableAccess(false).build();
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)new ViewExpanderImpl(), (SqlValidator)this.validator, (Prepare.CatalogReader)this.createCatalogReader(), cluster, this.convertletTable, config);
        this.rel = sqlToRelConverter.convertQuery(this.validatedSqlNode, false, true);
        this.rel = sqlToRelConverter.flattenTypes(this.rel, true);
        this.rel = RelDecorrelator.decorrelateQuery(this.rel);
        this.state = State.STATE_5_CONVERTED;
        return this.rel;
    }

    private CalciteCatalogReader createCatalogReader() {
        SchemaPlus rootSchema = PlannerImpl.rootSchema(this.defaultSchema);
        return new CalciteCatalogReader(CalciteSchemaImpl.from(rootSchema), this.parserConfig.caseSensitive(), CalciteSchemaImpl.from(this.defaultSchema).path(null), this.typeFactory);
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        while (schema.getParentSchema() != null) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.typeFactory);
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) throws RelConversionException {
        RelTraitSet designedTraitSet = requiredOutputTraits.simplify();
        this.ensure(State.STATE_5_CONVERTED);
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(this.planner, rel, designedTraitSet);
    }

    private static enum State {
        STATE_0_CLOSED{

            @Override
            void from(PlannerImpl planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            @Override
            void from(PlannerImpl planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            @Override
            void from(PlannerImpl planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(PlannerImpl planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }

    public class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        @Override
        public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
            Prepare.CatalogReader catalogReader = PlannerImpl.this.createCatalogReader().withSchemaPath((List)schemaPath);
            return this.expandViewHelper(queryString, (CalciteCatalogReader)catalogReader);
        }

        @Override
        public RelNode expandView(RelDataType rowType, String queryString, SchemaPlus rootSchema, List<String> schemaPath) {
            Prepare.CatalogReader catalogReader = new CalciteCatalogReader(CalciteSchemaImpl.from(rootSchema), PlannerImpl.this.parserConfig.caseSensitive(), CalciteSchemaImpl.from(PlannerImpl.this.defaultSchema).path(null), PlannerImpl.this.typeFactory).withSchemaPath((List)schemaPath);
            return this.expandViewHelper(queryString, (CalciteCatalogReader)catalogReader);
        }

        private RelNode expandViewHelper(String queryString, CalciteCatalogReader catalogReader) {
            SqlNode sqlNode;
            SqlParser parser = SqlParser.create(queryString, PlannerImpl.this.parserConfig);
            try {
                sqlNode = parser.parseQuery();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed", e);
            }
            CalciteSqlValidator validator = new CalciteSqlValidator(PlannerImpl.this.operatorTable, catalogReader, PlannerImpl.this.typeFactory);
            validator.setIdentifierExpansion(true);
            SqlNode validatedSqlNode = validator.validate(sqlNode);
            RexBuilder rexBuilder = PlannerImpl.this.createRexBuilder();
            RelOptCluster cluster = RelOptCluster.create(PlannerImpl.this.planner, rexBuilder);
            SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(false).withConvertTableAccess(false).build();
            SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)new ViewExpanderImpl(), (SqlValidator)validator, (Prepare.CatalogReader)catalogReader, cluster, PlannerImpl.this.convertletTable, config);
            RelNode rel = sqlToRelConverter.convertQuery(validatedSqlNode, true, false);
            rel = sqlToRelConverter.flattenTypes(rel, true);
            rel = RelDecorrelator.decorrelateQuery(rel);
            return rel;
        }
    }
}

