/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.SubstitutionVisitor;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexShuttle;
import java.util.List;

public class MaterializedViewSubstitutionVisitor
extends SubstitutionVisitor {
    private static final ImmutableList<SubstitutionVisitor.UnifyRule> EXTENDED_RULES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)DEFAULT_RULES)).add(ProjectToProjectUnifyRule1.INSTANCE)).build();

    public MaterializedViewSubstitutionVisitor(RelNode target_, RelNode query_) {
        super(target_, query_, EXTENDED_RULES);
    }

    @Override
    public RelNode go(RelNode replacement_) {
        return super.go(replacement_);
    }

    private static class ProjectToProjectUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final ProjectToProjectUnifyRule1 INSTANCE = new ProjectToProjectUnifyRule1();

        private ProjectToProjectUnifyRule1() {
            super(ProjectToProjectUnifyRule1.operand(SubstitutionVisitor.MutableProject.class, ProjectToProjectUnifyRule1.query(0)), ProjectToProjectUnifyRule1.operand(SubstitutionVisitor.MutableProject.class, ProjectToProjectUnifyRule1.target(0)), 1);
        }

        @Override
        protected SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            List<RexNode> newProjects;
            SubstitutionVisitor.MutableProject query = (SubstitutionVisitor.MutableProject)call.query;
            List<RelDataTypeField> oldFieldList = query.getInput().getRowType().getFieldList();
            List<RelDataTypeField> newFieldList = call.target.getRowType().getFieldList();
            try {
                newProjects = this.transformRex(query.getProjects(), oldFieldList, newFieldList);
            }
            catch (SubstitutionVisitor.MatchFailed e) {
                return null;
            }
            SubstitutionVisitor.MutableProject newProject = SubstitutionVisitor.MutableProject.of(query.getRowType(), call.target, newProjects);
            SubstitutionVisitor.MutableRel newProject2 = SubstitutionVisitor.MutableRels.strip(newProject);
            return call.result(newProject2);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, SubstitutionVisitor.MutableRel query, SubstitutionVisitor.MutableRel target) {
            assert (query instanceof SubstitutionVisitor.MutableProject && target instanceof SubstitutionVisitor.MutableProject);
            if (this.queryOperand.matches(visitor, query)) {
                SubstitutionVisitor.MutableProject queryProject;
                if (this.targetOperand.matches(visitor, target)) {
                    return null;
                }
                if (this.targetOperand.isWeaker(visitor, target) && (queryProject = (SubstitutionVisitor.MutableProject)query).getInput() instanceof SubstitutionVisitor.MutableFilter) {
                    RexNode newCondition;
                    SubstitutionVisitor.MutableFilter innerFilter = (SubstitutionVisitor.MutableFilter)queryProject.getInput();
                    try {
                        newCondition = this.transformRex(innerFilter.getCondition(), innerFilter.getInput().getRowType().getFieldList(), target.getRowType().getFieldList());
                    }
                    catch (SubstitutionVisitor.MatchFailed e) {
                        return null;
                    }
                    SubstitutionVisitor.MutableFilter newFilter = SubstitutionVisitor.MutableFilter.of(target, newCondition);
                    SubstitutionVisitor substitutionVisitor = visitor;
                    substitutionVisitor.getClass();
                    return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, newFilter, this.copy(visitor.slots, this.slotCount));
                }
            }
            return null;
        }

        private RexNode transformRex(RexNode node, List<RelDataTypeField> oldFields, List<RelDataTypeField> newFields) {
            List<RexNode> nodes = this.transformRex(ImmutableList.of(node), oldFields, newFields);
            return nodes.get(0);
        }

        private List<RexNode> transformRex(List<RexNode> nodes, final List<RelDataTypeField> oldFields, final List<RelDataTypeField> newFields) {
            RexShuttle shuttle = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef ref) {
                    RelDataTypeField f = (RelDataTypeField)oldFields.get(ref.getIndex());
                    for (int index = 0; index < newFields.size(); ++index) {
                        RelDataTypeField newf = (RelDataTypeField)newFields.get(index);
                        if (!((String)f.getKey()).equals(newf.getKey()) || f.getValue() != newf.getValue()) continue;
                        return new RexInputRef(index, (RelDataType)f.getValue());
                    }
                    throw SubstitutionVisitor.MatchFailed.INSTANCE;
                }
            };
            return shuttle.apply(nodes);
        }
    }
}

