/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.jdbc.CalciteRootSchema;
import hive.org.apache.calcite.jdbc.CalciteSchema;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.materialize.Lattice;
import hive.org.apache.calcite.schema.Function;
import hive.org.apache.calcite.schema.Schema;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.schema.impl.MaterializedViewTable;
import hive.org.apache.calcite.schema.impl.StarTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;

public abstract class CalciteAbstractSchema
implements CalciteSchema {
    protected final CalciteSchema parent;
    protected final Schema schema;
    protected final String name;
    private ImmutableList<ImmutableList<String>> path;

    public CalciteAbstractSchema(CalciteSchema parent, Schema schema, String name) {
        this.parent = parent;
        this.schema = schema;
        this.name = name;
    }

    @Override
    public CalciteSchema getParent() {
        return this.parent;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CalciteSchema.TableEntry add(String tableName, Table table) {
        return this.add(tableName, table, ImmutableList.of());
    }

    @Override
    public CalciteRootSchema root() {
        CalciteSchema schema = this;
        while (schema.getParent() != null) {
            schema = schema.getParent();
        }
        return (CalciteRootSchema)schema;
    }

    @Override
    public List<String> path(String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        for (CalciteSchema s = this; s != null; s = s.getParent()) {
            if (s.getParent() == null && s.getName().equals("")) continue;
            list.add(s.getName());
        }
        return ImmutableList.copyOf(Lists.reverse(list));
    }

    @Override
    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    @Override
    public List<? extends List<String>> getPath() {
        if (this.path != null) {
            return this.path;
        }
        return ImmutableList.of(this.path(null));
    }

    public static CalciteSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).calciteSchema();
    }

    public static class LatticeEntryImpl
    extends CalciteSchema.LatticeEntry {
        private final Lattice lattice;
        private final CalciteSchema.TableEntry starTableEntry;

        public LatticeEntryImpl(CalciteSchema schema, String name, Lattice lattice) {
            super(schema, name);
            this.lattice = lattice;
            StarTable starTable = lattice.createStarTable();
            this.starTableEntry = schema.add(name, starTable);
        }

        @Override
        public Lattice getLattice() {
            return this.lattice;
        }

        @Override
        public CalciteSchema.TableEntry getStarTable() {
            return this.starTableEntry;
        }
    }

    public static class FunctionEntryImpl
    extends CalciteSchema.FunctionEntry {
        private final Function function;

        public FunctionEntryImpl(CalciteSchema schema, String name, Function function) {
            super(schema, name);
            this.function = function;
        }

        @Override
        public Function getFunction() {
            return this.function;
        }

        @Override
        public boolean isMaterialization() {
            return this.function instanceof MaterializedViewTable.MaterializedViewTableMacro;
        }
    }

    public static class TableEntryImpl
    extends CalciteSchema.TableEntry {
        private final Table table;

        public TableEntryImpl(CalciteSchema schema, String name, Table table, ImmutableList<String> sqls) {
            super(schema, name, sqls);
            assert (table != null);
            this.table = Preconditions.checkNotNull(table);
        }

        @Override
        public Table getTable() {
            return this.table;
        }
    }

    private class SchemaPlusImpl
    implements SchemaPlus {
        private SchemaPlusImpl() {
        }

        CalciteSchema calciteSchema() {
            return CalciteAbstractSchema.this;
        }

        @Override
        public SchemaPlus getParentSchema() {
            return CalciteAbstractSchema.this.parent == null ? null : CalciteAbstractSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return CalciteAbstractSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return CalciteAbstractSchema.this.schema.isMutable();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            CalciteAbstractSchema.this.setCache(cache);
        }

        @Override
        public boolean isCacheEnabled() {
            return CalciteAbstractSchema.this.isCacheEnabled();
        }

        @Override
        public boolean contentsHaveChangedSince(long lastCheck, long now) {
            return CalciteAbstractSchema.this.schema.contentsHaveChangedSince(lastCheck, now);
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return CalciteAbstractSchema.this.schema.getExpression(parentSchema, name);
        }

        @Override
        public Table getTable(String name) {
            CalciteSchema.TableEntry entry = CalciteAbstractSchema.this.getTable(name, true);
            return entry == null ? null : entry.getTable();
        }

        public NavigableSet<String> getTableNames() {
            return CalciteAbstractSchema.this.getTableNames();
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return CalciteAbstractSchema.this.getFunctions(name, true);
        }

        public NavigableSet<String> getFunctionNames() {
            return CalciteAbstractSchema.this.getFunctionNames();
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            CalciteSchema subSchema = CalciteAbstractSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return CalciteAbstractSchema.this.getSubSchemaMap().keySet();
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            CalciteSchema calciteSchema = CalciteAbstractSchema.this.add(name, schema);
            return calciteSchema.plus();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(CalciteAbstractSchema.this)) {
                return clazz.cast(CalciteAbstractSchema.this);
            }
            if (clazz.isInstance(CalciteAbstractSchema.this.schema)) {
                return clazz.cast(CalciteAbstractSchema.this.schema);
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            CalciteAbstractSchema.this.path = path;
        }

        @Override
        public void add(String name, Table table) {
            CalciteAbstractSchema.this.add(name, table);
        }

        @Override
        public void add(String name, Function function) {
            CalciteAbstractSchema.this.add(name, function);
        }

        @Override
        public void add(String name, Lattice lattice) {
            CalciteAbstractSchema.this.add(name, lattice);
        }
    }
}

