/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.linq4j.tree.Types;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.prepare.Prepare;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.TableModify;
import hive.org.apache.calcite.schema.ModifiableTable;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnumerableTableModify
extends TableModify
implements EnumerableRel {
    public EnumerableTableModify(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, boolean flattened) {
        super(cluster, traits, table, catalogReader, child, operation, updateColumnList, flattened);
        assert (child.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() instanceof EnumerableConvention);
        ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
        if (modifiableTable == null) {
            throw new AssertionError();
        }
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), EnumerableTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.isFlattened());
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression convertedChildExp;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result result = implementor.visitChild(this, 0, (EnumerableRel)this.getInput(), pref);
        Expression childExp = builder.append("child", result.block);
        ParameterExpression collectionParameter = Expressions.parameter(Collection.class, (String)builder.newName("collection"));
        Expression expression = this.table.getExpression(ModifiableTable.class);
        assert (expression != null);
        assert (ModifiableTable.class.isAssignableFrom(Types.toClass((Type)expression.getType()))) : expression.getType();
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)collectionParameter, (Expression)Expressions.call((Expression)expression, (Method)BuiltInMethod.MODIFIABLE_TABLE_GET_MODIFIABLE_COLLECTION.method, (Expression[])new Expression[0])));
        Expression countParameter = builder.append("count", (Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), false);
        if (!this.getInput().getRowType().equals(this.getRowType())) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            PhysType physType = PhysTypeImpl.of(typeFactory, this.table.getRowType(), JavaRowFormat.CUSTOM);
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            PhysType childPhysType = result.physType;
            ParameterExpression o_ = Expressions.parameter((Type)childPhysType.getJavaRowType(), (String)"o");
            int fieldCount = childPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                expressionList.add(childPhysType.fieldReference((Expression)o_, i, physType.getJavaFieldType(i)));
            }
            convertedChildExp = builder.append("convertedChild", (Expression)Expressions.call((Expression)childExp, (Method)BuiltInMethod.SELECT.method, (Expression[])new Expression[]{Expressions.lambda((Expression)physType.record(expressionList), (ParameterExpression[])new ParameterExpression[]{o_})}));
        } else {
            convertedChildExp = childExp;
        }
        builder.add(Expressions.statement((Expression)Expressions.call((Expression)convertedChildExp, (String)"into", (Expression[])new Expression[]{collectionParameter})));
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)Expressions.subtract((Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), (Expression)countParameter), Long.TYPE)})));
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref == EnumerableRel.Prefer.ARRAY ? JavaRowFormat.ARRAY : JavaRowFormat.SCALAR);
        return implementor.result(physType, builder.toBlock());
    }
}

