/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.EnumUtils;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Primitive;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Correlate;
import hive.org.apache.calcite.rel.core.CorrelationId;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.sql.SemiJoinType;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class EnumerableCorrelate
extends Correlate
implements EnumerableRel {
    public EnumerableCorrelate(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        super(cluster, traits, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public EnumerableCorrelate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, SemiJoinType joinType) {
        return new EnumerableCorrelate(this.getCluster(), traitSet, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ParameterExpression corrRef;
        ParameterExpression corrArg;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        BlockBuilder corrBlock = new BlockBuilder();
        Type corrVarType = leftResult.physType.getJavaRowType();
        if (!Primitive.is((Type)corrVarType)) {
            corrRef = corrArg = Expressions.parameter((int)16, (Type)corrVarType, (String)this.getCorrelVariable());
        } else {
            corrArg = Expressions.parameter((int)16, (Type)Primitive.box((Type)corrVarType), (String)("$box" + this.getCorrelVariable()));
            corrRef = (ParameterExpression)corrBlock.append(this.getCorrelVariable(), Expressions.unbox((Expression)corrArg));
        }
        implementor.registerCorrelVariable(this.getCorrelVariable(), corrRef, corrBlock, leftResult.physType);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        implementor.clearCorrelVariable(this.getCorrelVariable());
        corrBlock.add((Statement)rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        Expression selector = EnumUtils.joinSelector(this.joinType.returnsJustFirstInput() ? this.joinType.toJoinType() : JoinRelType.INNER, physType, ImmutableList.of(leftResult.physType, rightResult.physType));
        builder.append((Expression)Expressions.call((Expression)leftExpression, (Method)BuiltInMethod.CORRELATE_JOIN.method, (Expression[])new Expression[]{Expressions.constant((Object)this.joinType.toLinq4j()), Expressions.lambda((BlockStatement)corrBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{corrArg}), selector}));
        return implementor.result(physType, builder.toBlock());
    }
}

