/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.LargeBuffer;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

public final class UnsafeDirectLittleEndian
extends WrappedByteBuf {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    public final long id = ID_GENERATOR.incrementAndGet();
    private final AbstractByteBuf wrapped;
    private final long memoryAddress;
    private final AtomicLong bufferCount;
    private final AtomicLong bufferSize;
    private final long initCap;
    public static final boolean ASSERT_ENABLED;

    UnsafeDirectLittleEndian(DuplicatedByteBuf buf) {
        this((AbstractByteBuf)buf, true, null, null);
    }

    UnsafeDirectLittleEndian(LargeBuffer buf) {
        this(buf, true, null, null);
    }

    UnsafeDirectLittleEndian(PooledUnsafeDirectByteBuf buf, AtomicLong bufferCount, AtomicLong bufferSize) {
        this((AbstractByteBuf)buf, true, bufferCount, bufferSize);
    }

    private UnsafeDirectLittleEndian(AbstractByteBuf buf, boolean fake, AtomicLong bufferCount, AtomicLong bufferSize) {
        super((ByteBuf)buf);
        if (!NATIVE_ORDER || buf.order() != ByteOrder.BIG_ENDIAN) {
            throw new IllegalStateException("Drill only runs on LittleEndian systems.");
        }
        this.bufferCount = bufferCount;
        this.bufferSize = bufferSize;
        this.initCap = ASSERT_ENABLED ? (long)buf.capacity() : -1L;
        this.wrapped = buf;
        this.memoryAddress = buf.memoryAddress();
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    public long getLong(int index) {
        long v = PlatformDependent.getLong((long)this.addr(index));
        return v;
    }

    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public ByteBuf slice() {
        return this.slice(this.readerIndex(), this.readableBytes());
    }

    public ByteBuf slice(int index, int length) {
        return new SlicedByteBuf((ByteBuf)this, index, length);
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public int getInt(int index) {
        int v = PlatformDependent.getInt((long)this.addr(index));
        return v;
    }

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public short getShort(int index) {
        short v = PlatformDependent.getShort((long)this.addr(index));
        return v;
    }

    public ByteBuf setShort(int index, int value) {
        this.wrapped.checkIndex(index, 2);
        this._setShort(index, value);
        return this;
    }

    public ByteBuf setInt(int index, int value) {
        this.wrapped.checkIndex(index, 4);
        this._setInt(index, value);
        return this;
    }

    public ByteBuf setLong(int index, long value) {
        this.wrapped.checkIndex(index, 8);
        this._setLong(index, value);
        return this;
    }

    public ByteBuf setChar(int index, int value) {
        this.setShort(index, value);
        return this;
    }

    public ByteBuf setFloat(int index, float value) {
        this.setInt(index, Float.floatToRawIntBits(value));
        return this;
    }

    public ByteBuf setDouble(int index, double value) {
        this.setLong(index, Double.doubleToRawLongBits(value));
        return this;
    }

    public ByteBuf writeShort(int value) {
        this.wrapped.ensureWritable(2);
        this._setShort(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 2;
        return this;
    }

    public ByteBuf writeInt(int value) {
        this.wrapped.ensureWritable(4);
        this._setInt(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 4;
        return this;
    }

    public ByteBuf writeLong(long value) {
        this.wrapped.ensureWritable(8);
        this._setLong(this.wrapped.writerIndex, value);
        this.wrapped.writerIndex += 8;
        return this;
    }

    public ByteBuf writeChar(int value) {
        this.writeShort(value);
        return this;
    }

    public ByteBuf writeFloat(float value) {
        this.writeInt(Float.floatToRawIntBits(value));
        return this;
    }

    public ByteBuf writeDouble(double value) {
        this.writeLong(Double.doubleToRawLongBits(value));
        return this;
    }

    private void _setShort(int index, int value) {
        PlatformDependent.putShort((long)this.addr(index), (short)((short)value));
    }

    private void _setInt(int index, int value) {
        PlatformDependent.putInt((long)this.addr(index), (int)value);
    }

    private void _setLong(int index, long value) {
        PlatformDependent.putLong((long)this.addr(index), (long)value);
    }

    public byte getByte(int index) {
        return PlatformDependent.getByte((long)this.addr(index));
    }

    public ByteBuf setByte(int index, int value) {
        PlatformDependent.putByte((long)this.addr(index), (byte)((byte)value));
        return this;
    }

    public boolean release() {
        return this.release(1);
    }

    public boolean release(int decrement) {
        boolean released = super.release(decrement);
        if (ASSERT_ENABLED && released && this.bufferCount != null && this.bufferSize != null) {
            this.bufferCount.decrementAndGet();
            this.bufferSize.addAndGet(-this.initCap);
        }
        return released;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    static {
        boolean isAssertEnabled = false;
        if (!$assertionsDisabled) {
            isAssertEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ENABLED = isAssertEnabled;
    }
}

