/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AppsBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(AppsBlock.class);
    protected ApplicationBaseProtocol appBaseProt;

    @Inject
    AppsBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(ctx);
        this.appBaseProt = appBaseProt;
    }

    public void render(HtmlBlock.Block html) {
        this.setTitle("Applications");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI")._())._()).tbody();
        EnumSet<YarnApplicationState> reqAppStates = EnumSet.noneOf(YarnApplicationState.class);
        String reqStateString = this.$("app.state");
        if (reqStateString != null && !reqStateString.isEmpty()) {
            String[] appStateStrings;
            for (String stateString : appStateStrings = reqStateString.split(",")) {
                reqAppStates.add(YarnApplicationState.valueOf((String)stateString.trim()));
            }
        }
        UserGroupInformation callerUGI = this.getCallerUGI();
        Collection appReports = null;
        try {
            final GetApplicationsRequest request = GetApplicationsRequest.newInstance(reqAppStates);
            appReports = callerUGI == null ? this.appBaseProt.getApplications(request).getApplicationList() : (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationReport>>(){

                @Override
                public Collection<ApplicationReport> run() throws Exception {
                    return AppsBlock.this.appBaseProt.getApplications(request).getApplicationList();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the applications.";
            LOG.error((Object)message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (ApplicationReport appReport : appReports) {
            String trackingURL;
            if (!reqAppStates.isEmpty() && !reqAppStates.contains(appReport.getYarnApplicationState())) continue;
            AppInfo app = new AppInfo(appReport);
            String percent = String.format("%.1f", Float.valueOf(app.getProgress()));
            appsTableData.append("[\"<a href='").append(this.url(new String[]{"app", app.getAppId()})).append("'>").append(app.getAppId()).append("</a>\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getUser()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getType()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getQueue()))).append("\",\"").append(app.getStartedTime()).append("\",\"").append(app.getFinishedTime()).append("\",\"").append((Object)(app.getAppState() == null ? "N/A" : app.getAppState())).append("\",\"").append(app.getFinalAppStatus()).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a ");
            String string = trackingURL = app.getTrackingUrl() == null || app.getTrackingUrl() == "N/A" ? null : app.getTrackingUrl();
            String trackingUI = app.getTrackingUrl() == null || app.getTrackingUrl() == "N/A" ? "Unassigned" : (app.getAppState() == YarnApplicationState.FINISHED || app.getAppState() == YarnApplicationState.FAILED || app.getAppState() == YarnApplicationState.KILLED ? "History" : "ApplicationMaster");
            appsTableData.append(trackingURL == null ? "#" : "href='" + trackingURL).append("'>").append(trackingUI).append("</a>\"],\n");
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var appsTableData=" + appsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

