/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.rules.FilterSetOpTransposeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlDialect;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.jdbc.DrillJdbcRuleBase;
import org.apache.drill.exec.store.jdbc.JdbcDrel;
import org.apache.drill.exec.store.jdbc.JdbcIntermediatePrel;
import org.apache.drill.exec.store.jdbc.JdbcStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStoragePlugin.class);
    private static String[] RULES_TO_AVOID = new String[]{"JdbcToEnumerableConverterRule", "JdbcFilterRule", "JdbcProjectRule"};
    private final JdbcStorageConfig config;
    private final DrillbitContext context;
    private final DataSource source;
    private final String name;
    private final SqlDialect dialect;
    private final DrillJdbcConvention convention;
    private static final JdbcPrule JDBC_PRULE_INSTANCE = new JdbcPrule();

    public JdbcStoragePlugin(JdbcStorageConfig config, DrillbitContext context, String name) {
        this.context = context;
        this.config = config;
        this.name = name;
        BasicDataSource source = new BasicDataSource();
        source.setDriverClassName(config.getDriver());
        source.setUrl(config.getUrl());
        if (config.getUsername() != null) {
            source.setUsername(config.getUsername());
        }
        if (config.getPassword() != null) {
            source.setPassword(config.getPassword());
        }
        this.source = source;
        this.dialect = JdbcSchema.createDialect((DataSource)source);
        this.convention = new DrillJdbcConvention(this.dialect, name);
    }

    private static boolean canJoinOnCondition(RexNode node) {
        switch (node.getKind()) {
            case AND: 
            case OR: {
                List operands = ((RexCall)node).getOperands();
                for (RexNode operand : operands) {
                    if (JdbcStoragePlugin.canJoinOnCondition(operand)) continue;
                    return false;
                }
                return true;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List operands = ((RexCall)node).getOperands();
                if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) break;
                return true;
            }
        }
        return false;
    }

    public void registerSchemas(SchemaConfig config, SchemaPlus parent) {
        JdbcCatalogSchema schema = new JdbcCatalogSchema(this.name);
        SchemaPlus holder = parent.add(this.name, (Schema)schema);
        schema.setHolder(holder);
    }

    public JdbcStorageConfig getConfig() {
        return this.config;
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public boolean supportsRead() {
        return true;
    }

    public DataSource getSource() {
        return this.source;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }

    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<RelOptRule> getPhysicalOptimizerRules(OptimizerRulesContext context) {
        return this.convention.getRules();
    }

    private class JdbcCatalogSchema
    extends AbstractSchema {
        private final Map<String, CapitalizingJdbcSchema> schemaMap;
        private final CapitalizingJdbcSchema defaultSchema;

        public JdbcCatalogSchema(String name) {
            super((List)ImmutableList.of(), name);
            this.schemaMap = Maps.newHashMap();
            try (Connection con = JdbcStoragePlugin.this.source.getConnection();
                 ResultSet set = con.getMetaData().getCatalogs();){
                while (set.next()) {
                    String catalogName = set.getString(1);
                    CapitalizingJdbcSchema schema = new CapitalizingJdbcSchema(this.getSchemaPath(), catalogName, JdbcStoragePlugin.this.source, JdbcStoragePlugin.this.dialect, JdbcStoragePlugin.this.convention, catalogName, null);
                    this.schemaMap.put(catalogName, schema);
                }
            }
            catch (SQLException e) {
                logger.warn("Failure while attempting to load JDBC schema.", (Throwable)e);
            }
            if (this.schemaMap.isEmpty()) {
                boolean schemasAdded = this.addSchemas();
                if (!schemasAdded) {
                    this.schemaMap.put("default", new CapitalizingJdbcSchema((List<String>)ImmutableList.of(), name, JdbcStoragePlugin.this.source, JdbcStoragePlugin.this.dialect, JdbcStoragePlugin.this.convention, null, null));
                }
            } else {
                this.addSchemas();
            }
            this.defaultSchema = this.schemaMap.values().iterator().next();
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                CapitalizingJdbcSchema inner = this.getSubSchema(s);
                SchemaPlus holder = plusOfThis.add(s, (Schema)inner);
                inner.setHolder(holder);
            }
        }

        private boolean addSchemas() {
            boolean added = false;
            try (Connection con = JdbcStoragePlugin.this.source.getConnection();
                 ResultSet set = con.getMetaData().getSchemas();){
                while (set.next()) {
                    CapitalizingJdbcSchema schema;
                    String schemaName = set.getString(1);
                    String catalogName = set.getString(2);
                    CapitalizingJdbcSchema parentSchema = this.schemaMap.get(catalogName);
                    if (parentSchema == null) {
                        schema = new CapitalizingJdbcSchema(this.getSchemaPath(), schemaName, JdbcStoragePlugin.this.source, JdbcStoragePlugin.this.dialect, JdbcStoragePlugin.this.convention, catalogName, schemaName);
                        this.schemaMap.put(schemaName, schema);
                    } else {
                        schema = new CapitalizingJdbcSchema(parentSchema.getSchemaPath(), schemaName, JdbcStoragePlugin.this.source, JdbcStoragePlugin.this.dialect, JdbcStoragePlugin.this.convention, catalogName, schemaName);
                        parentSchema.schemaMap.put(schemaName, schema);
                    }
                    added = true;
                }
            }
            catch (SQLException e) {
                logger.warn("Failure while attempting to load JDBC schema.", (Throwable)e);
            }
            return added;
        }

        public String getTypeName() {
            return "jdbc";
        }

        public Schema getDefaultSchema() {
            return this.defaultSchema;
        }

        public CapitalizingJdbcSchema getSubSchema(String name) {
            return this.schemaMap.get(name);
        }

        public Set<String> getSubSchemaNames() {
            return this.schemaMap.keySet();
        }

        public Table getTable(String name) {
            Schema schema = this.getDefaultSchema();
            if (schema != null) {
                try {
                    Table t = schema.getTable(name);
                    if (t != null) {
                        return t;
                    }
                    return schema.getTable(name.toUpperCase());
                }
                catch (RuntimeException e) {
                    logger.warn("Failure while attempting to read table '{}' from JDBC source.", (Object)name, (Object)e);
                }
            }
            return null;
        }

        public Set<String> getTableNames() {
            return this.defaultSchema.getTableNames();
        }
    }

    private class CapitalizingJdbcSchema
    extends AbstractSchema {
        final Map<String, CapitalizingJdbcSchema> schemaMap;
        private final JdbcSchema inner;

        public CapitalizingJdbcSchema(List<String> parentSchemaPath, String name, DataSource dataSource, SqlDialect dialect, JdbcConvention convention, String catalog, String schema) {
            super(parentSchemaPath, name);
            this.schemaMap = Maps.newHashMap();
            this.inner = new JdbcSchema(dataSource, dialect, convention, catalog, schema);
        }

        public String getTypeName() {
            return "jdbc";
        }

        public Collection<Function> getFunctions(String name) {
            return this.inner.getFunctions(name);
        }

        public Set<String> getFunctionNames() {
            return this.inner.getFunctionNames();
        }

        public CapitalizingJdbcSchema getSubSchema(String name) {
            return this.schemaMap.get(name);
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                CapitalizingJdbcSchema inner = this.getSubSchema(s);
                SchemaPlus holder = plusOfThis.add(s, (Schema)inner);
                inner.setHolder(holder);
            }
        }

        public Set<String> getSubSchemaNames() {
            return this.schemaMap.keySet();
        }

        public Set<String> getTableNames() {
            return this.inner.getTableNames();
        }

        public String toString() {
            return Joiner.on((String)".").join((Iterable)this.getSchemaPath());
        }

        public Table getTable(String name) {
            Table table = this.inner.getTable(name);
            if (table != null) {
                return table;
            }
            return this.inner.getTable(name.toUpperCase());
        }
    }

    private class JdbcDrelConverterRule
    extends ConverterRule {
        public JdbcDrelConverterRule(DrillJdbcConvention in) {
            super(RelNode.class, (RelTrait)in, (RelTrait)DrillRel.DRILL_LOGICAL, "JDBC_DREL_Converter" + in.getName());
        }

        public RelNode convert(RelNode in) {
            return new JdbcDrel(in.getCluster(), in.getTraitSet().replace((RelTrait)DrillRel.DRILL_LOGICAL), JdbcDrelConverterRule.convert((RelNode)in, (RelTraitSet)in.getTraitSet().replace(this.getInTrait())));
        }
    }

    private static class JdbcPrule
    extends ConverterRule {
        private JdbcPrule() {
            super(JdbcDrel.class, (RelTrait)DrillRel.DRILL_LOGICAL, (RelTrait)Prel.DRILL_PHYSICAL, "JDBC_PREL_Converter");
        }

        public RelNode convert(RelNode in) {
            return new JdbcIntermediatePrel(in.getCluster(), in.getTraitSet().replace(this.getOutTrait()), in.getInput(0));
        }
    }

    class DrillJdbcConvention
    extends JdbcConvention {
        private final ImmutableSet<RelOptRule> rules;

        public DrillJdbcConvention(SqlDialect dialect, String name) {
            super(dialect, (Expression)ConstantUntypedNull.INSTANCE, name);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add((Object)JDBC_PRULE_INSTANCE);
            builder.add((Object)new JdbcDrelConverterRule(this));
            builder.add((Object)new DrillJdbcRuleBase.DrillJdbcProjectRule(this));
            builder.add((Object)new DrillJdbcRuleBase.DrillJdbcFilterRule(this));
            block0: for (RelOptRule rule : JdbcRules.rules((JdbcConvention)this)) {
                String description = rule.toString();
                for (String black : RULES_TO_AVOID) {
                    if (description.equals(black)) continue block0;
                }
                builder.add((Object)rule);
            }
            builder.add((Object)FilterSetOpTransposeRule.INSTANCE);
            builder.add((Object)ProjectRemoveRule.INSTANCE);
            this.rules = builder.build();
        }

        public void register(RelOptPlanner planner) {
            for (RelOptRule rule : this.rules) {
                planner.addRule(rule);
            }
        }

        public Set<RelOptRule> getRules() {
            return this.rules;
        }

        public JdbcStoragePlugin getPlugin() {
            return JdbcStoragePlugin.this;
        }
    }
}

