/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Calendar;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcRecordReader
extends AbstractRecordReader {
    static final Logger logger = LoggerFactory.getLogger(JdbcRecordReader.class);
    private static final ImmutableMap<Integer, TypeProtos.MinorType> JDBC_TYPE_MAPPINGS = ImmutableMap.builder().put((Object)8, (Object)TypeProtos.MinorType.FLOAT8).put((Object)6, (Object)TypeProtos.MinorType.FLOAT4).put((Object)-6, (Object)TypeProtos.MinorType.INT).put((Object)5, (Object)TypeProtos.MinorType.INT).put((Object)4, (Object)TypeProtos.MinorType.INT).put((Object)-5, (Object)TypeProtos.MinorType.BIGINT).put((Object)1, (Object)TypeProtos.MinorType.VARCHAR).put((Object)12, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-1, (Object)TypeProtos.MinorType.VARCHAR).put((Object)2005, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-15, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-9, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-16, (Object)TypeProtos.MinorType.VARCHAR).put((Object)-3, (Object)TypeProtos.MinorType.VARBINARY).put((Object)-4, (Object)TypeProtos.MinorType.VARBINARY).put((Object)2004, (Object)TypeProtos.MinorType.VARBINARY).put((Object)2, (Object)TypeProtos.MinorType.FLOAT8).put((Object)3, (Object)TypeProtos.MinorType.FLOAT8).put((Object)7, (Object)TypeProtos.MinorType.FLOAT8).put((Object)91, (Object)TypeProtos.MinorType.DATE).put((Object)92, (Object)TypeProtos.MinorType.TIME).put((Object)93, (Object)TypeProtos.MinorType.TIMESTAMP).put((Object)16, (Object)TypeProtos.MinorType.BIT).put((Object)-7, (Object)TypeProtos.MinorType.BIT).build();
    private final DataSource source;
    private ResultSet resultSet;
    private final String storagePluginName;
    private FragmentContext fragmentContext;
    private Connection connection;
    private Statement statement;
    private final String sql;
    private ImmutableList<ValueVector> vectors;
    private ImmutableList<Copier<?>> copiers;
    private OperatorContext operatorContext;

    public JdbcRecordReader(FragmentContext fragmentContext, DataSource source, String sql, String storagePluginName) {
        this.fragmentContext = fragmentContext;
        this.source = source;
        this.sql = sql;
        this.storagePluginName = storagePluginName;
    }

    private static String nameFromType(int javaSqlType) {
        try {
            for (Field f : Types.class.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE || f.getInt(null) != javaSqlType) continue;
                return f.getName();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return Integer.toString(javaSqlType);
    }

    private Copier<?> getCopier(int jdbcType, int offset, ResultSet result, ValueVector v) {
        if (v instanceof NullableBigIntVector) {
            return new BigIntCopier(offset, result, (NullableBigIntVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableFloat4Vector) {
            return new Float4Copier(offset, result, (NullableFloat4Vector.Mutator)v.getMutator());
        }
        if (v instanceof NullableFloat8Vector) {
            return new Float8Copier(offset, result, (NullableFloat8Vector.Mutator)v.getMutator());
        }
        if (v instanceof NullableIntVector) {
            return new IntCopier(offset, result, (NullableIntVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableVarCharVector) {
            return new VarCharCopier(offset, result, (NullableVarCharVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableVarBinaryVector) {
            return new VarBinaryCopier(offset, result, (NullableVarBinaryVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableDateVector) {
            return new DateCopier(offset, result, (NullableDateVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableTimeVector) {
            return new TimeCopier(offset, result, (NullableTimeVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableTimeStampVector) {
            return new TimeStampCopier(offset, result, (NullableTimeStampVector.Mutator)v.getMutator());
        }
        if (v instanceof NullableBitVector) {
            return new BitCopier(offset, result, (NullableBitVector.Mutator)v.getMutator());
        }
        throw new IllegalArgumentException("Unknown how to handle vector.");
    }

    public void setup(OperatorContext operatorContext, OutputMutator output) throws ExecutionSetupException {
        try {
            this.operatorContext = operatorContext;
            this.connection = this.source.getConnection();
            this.statement = this.connection.createStatement();
            this.resultSet = this.statement.executeQuery(this.sql);
            ResultSetMetaData meta = this.resultSet.getMetaData();
            int columns = meta.getColumnCount();
            ImmutableList.Builder vectorBuilder = ImmutableList.builder();
            ImmutableList.Builder copierBuilder = ImmutableList.builder();
            for (int i = 1; i <= columns; ++i) {
                String name = meta.getColumnLabel(i);
                int jdbcType = meta.getColumnType(i);
                int width = meta.getPrecision(i);
                int scale = meta.getScale(i);
                TypeProtos.MinorType minorType = (TypeProtos.MinorType)JDBC_TYPE_MAPPINGS.get((Object)jdbcType);
                if (minorType == null) {
                    logger.warn("Ignoring column that is unsupported.", (Throwable)UserException.unsupportedError().message("A column you queried has a data type that is not currently supported by the JDBC storage plugin. The column's name was %s and its JDBC data type was %s. ", new Object[]{name, JdbcRecordReader.nameFromType(jdbcType)}).addContext("sql", this.sql).addContext("column Name", name).addContext("plugin", this.storagePluginName).build(logger));
                    continue;
                }
                TypeProtos.MajorType type = org.apache.drill.common.types.Types.optional((TypeProtos.MinorType)minorType);
                MaterializedField field = MaterializedField.create((String)name, (TypeProtos.MajorType)type);
                Class clazz = TypeHelper.getValueVectorClass((TypeProtos.MinorType)minorType, (TypeProtos.DataMode)type.getMode());
                ValueVector vector = output.addField(field, clazz);
                vectorBuilder.add((Object)vector);
                copierBuilder.add(this.getCopier(jdbcType, i, this.resultSet, vector));
            }
            this.vectors = vectorBuilder.build();
            this.copiers = copierBuilder.build();
        }
        catch (SQLException | SchemaChangeException e) {
            throw UserException.dataReadError((Throwable)e).message("The JDBC storage plugin failed while trying setup the SQL query. ", new Object[0]).addContext("sql", this.sql).addContext("plugin", this.storagePluginName).build(logger);
        }
    }

    public int next() {
        int counter;
        Boolean b = true;
        try {
            for (counter = 0; counter < 4095 && b.booleanValue() && (b = Boolean.valueOf(this.resultSet.next())).booleanValue(); ++counter) {
                for (Copier c : this.copiers) {
                    c.copy(counter);
                }
            }
        }
        catch (SQLException e) {
            throw UserException.dataReadError((Throwable)e).message("Failure while attempting to read from database.", new Object[0]).addContext("sql", this.sql).addContext("plugin", this.storagePluginName).build(logger);
        }
        for (ValueVector vv : this.vectors) {
            vv.getMutator().setValueCount(counter > 0 ? counter : 0);
        }
        return counter > 0 ? counter : 0;
    }

    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.resultSet, this.statement, this.connection});
    }

    private class BitCopier
    extends Copier<NullableBitVector.Mutator> {
        public BitCopier(int columnIndex, ResultSet result, NullableBitVector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            ((NullableBitVector.Mutator)this.mutator).setSafe(index, this.result.getBoolean(this.columnIndex) ? 1 : 0);
            if (this.result.wasNull()) {
                ((NullableBitVector.Mutator)this.mutator).setNull(index);
            }
        }
    }

    private class TimeStampCopier
    extends Copier<NullableTimeStampVector.Mutator> {
        private final Calendar calendar;

        public TimeStampCopier(int columnIndex, ResultSet result, NullableTimeStampVector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }

        @Override
        void copy(int index) throws SQLException {
            Timestamp stamp = this.result.getTimestamp(this.columnIndex, this.calendar);
            if (stamp != null) {
                ((NullableTimeStampVector.Mutator)this.mutator).setSafe(index, stamp.getTime());
            }
        }
    }

    private class TimeCopier
    extends Copier<NullableTimeVector.Mutator> {
        private final Calendar calendar;

        public TimeCopier(int columnIndex, ResultSet result, NullableTimeVector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }

        @Override
        void copy(int index) throws SQLException {
            Time time = this.result.getTime(this.columnIndex, this.calendar);
            if (time != null) {
                ((NullableTimeVector.Mutator)this.mutator).setSafe(index, (int)time.getTime());
            }
        }
    }

    private class DateCopier
    extends Copier<NullableDateVector.Mutator> {
        private final Calendar calendar;

        public DateCopier(int columnIndex, ResultSet result, NullableDateVector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }

        @Override
        void copy(int index) throws SQLException {
            Date date = this.result.getDate(this.columnIndex, this.calendar);
            if (date != null) {
                ((NullableDateVector.Mutator)this.mutator).setSafe(index, date.getTime());
            }
        }
    }

    private class VarBinaryCopier
    extends Copier<NullableVarBinaryVector.Mutator> {
        public VarBinaryCopier(int columnIndex, ResultSet result, NullableVarBinaryVector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            byte[] record = this.result.getBytes(this.columnIndex);
            if (record != null) {
                ((NullableVarBinaryVector.Mutator)this.mutator).setSafe(index, record, 0, record.length);
            }
        }
    }

    private class VarCharCopier
    extends Copier<NullableVarCharVector.Mutator> {
        public VarCharCopier(int columnIndex, ResultSet result, NullableVarCharVector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            String val = JdbcRecordReader.this.resultSet.getString(this.columnIndex);
            if (val != null) {
                byte[] record = val.getBytes(Charsets.UTF_8);
                ((NullableVarCharVector.Mutator)this.mutator).setSafe(index, record, 0, record.length);
            }
        }
    }

    private class DecimalCopier
    extends Copier<NullableFloat8Vector.Mutator> {
        public DecimalCopier(int columnIndex, ResultSet result, NullableFloat8Vector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            BigDecimal decimal = this.result.getBigDecimal(this.columnIndex);
            if (decimal != null) {
                ((NullableFloat8Vector.Mutator)this.mutator).setSafe(index, decimal.doubleValue());
            }
        }
    }

    private class Float8Copier
    extends Copier<NullableFloat8Vector.Mutator> {
        public Float8Copier(int columnIndex, ResultSet result, NullableFloat8Vector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            ((NullableFloat8Vector.Mutator)this.mutator).setSafe(index, this.result.getDouble(this.columnIndex));
            if (this.result.wasNull()) {
                ((NullableFloat8Vector.Mutator)this.mutator).setNull(index);
            }
        }
    }

    private class Float4Copier
    extends Copier<NullableFloat4Vector.Mutator> {
        public Float4Copier(int columnIndex, ResultSet result, NullableFloat4Vector.Mutator mutator) {
            super(JdbcRecordReader.this, columnIndex, result, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            ((NullableFloat4Vector.Mutator)this.mutator).setSafe(index, this.result.getFloat(this.columnIndex));
            if (this.result.wasNull()) {
                ((NullableFloat4Vector.Mutator)this.mutator).setNull(index);
            }
        }
    }

    private class BigIntCopier
    extends Copier<NullableBigIntVector.Mutator> {
        public BigIntCopier(int offset, ResultSet set, NullableBigIntVector.Mutator mutator) {
            super(JdbcRecordReader.this, offset, set, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            ((NullableBigIntVector.Mutator)this.mutator).setSafe(index, this.result.getLong(this.columnIndex));
            if (this.result.wasNull()) {
                ((NullableBigIntVector.Mutator)this.mutator).setNull(index);
            }
        }
    }

    private class IntCopier
    extends Copier<NullableIntVector.Mutator> {
        public IntCopier(int offset, ResultSet set, NullableIntVector.Mutator mutator) {
            super(JdbcRecordReader.this, offset, set, (ValueVector.Mutator)mutator);
        }

        @Override
        void copy(int index) throws SQLException {
            ((NullableIntVector.Mutator)this.mutator).setSafe(index, this.result.getInt(this.columnIndex));
            if (this.result.wasNull()) {
                ((NullableIntVector.Mutator)this.mutator).setNull(index);
            }
        }
    }

    private static abstract class Copier<T extends ValueVector.Mutator> {
        protected final int columnIndex;
        protected final ResultSet result;
        protected final T mutator;
        final /* synthetic */ JdbcRecordReader this$0;

        public Copier(int columnIndex, ResultSet result, T mutator) {
            this.this$0 = var1_1;
            this.columnIndex = columnIndex;
            this.result = result;
            this.mutator = mutator;
        }

        abstract void copy(int var1) throws SQLException;
    }
}

