/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jline.console.completer.StringsCompleter;
import sqlline.SqlLine;

class SqlCompleter
extends StringsCompleter {
    public SqlCompleter(SqlLine sqlLine, boolean skipMeta) throws IOException, SQLException {
        super(new String[0]);
        TreeSet<String> completions = new TreeSet<String>();
        String keywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream("sql-keywords.properties"))).readLine();
        DatabaseMetaData meta = sqlLine.getDatabaseConnection().meta;
        try {
            keywords = keywords + "," + meta.getSQLKeywords();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + meta.getStringFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + meta.getNumericFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + meta.getSystemFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + meta.getTimeDateFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        keywords = keywords + "," + keywords.toLowerCase();
        StringTokenizer tok = new StringTokenizer(keywords, ", ");
        while (tok.hasMoreTokens()) {
            completions.add(tok.nextToken());
        }
        if (!skipMeta) {
            completions.addAll(sqlLine.getColumnNames(meta));
        }
        this.getStrings().addAll(completions);
    }
}

