/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.SQLException;
import java.sql.Statement;

public class DispatchCallback {
    private Status status = Status.UNSET;
    private Statement statement;

    public void trackSqlQuery(Statement statement) {
        this.statement = statement;
        this.status = Status.RUNNING;
    }

    public void setToSuccess() {
        this.status = Status.SUCCESS;
    }

    public boolean isSuccess() {
        return Status.SUCCESS == this.status;
    }

    public void setToFailure() {
        this.status = Status.FAILURE;
    }

    public boolean isFailure() {
        return Status.FAILURE == this.status;
    }

    public boolean isRunning() {
        return Status.RUNNING == this.status;
    }

    public void setToCancel() {
        this.status = Status.CANCELED;
    }

    public boolean isCanceled() {
        return Status.CANCELED == this.status;
    }

    public void forceKillSqlQuery() throws SQLException {
        this.setStatus(Status.CANCELED);
        if (null != this.statement) {
            this.statement.cancel();
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        UNSET,
        RUNNING,
        SUCCESS,
        FAILURE,
        CANCELED;

    }
}

