/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicInteger;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

public class ParameterExpression
extends Expression {
    private static final AtomicInteger SEQ = new AtomicInteger();
    public final int modifier;
    public final String name;

    public ParameterExpression(Type type) {
        this(0, type, "p" + SEQ.getAndIncrement());
    }

    public ParameterExpression(int modifier, Type type, String name) {
        super(ExpressionType.Parameter, type);
        assert (name != null) : "name should not be null";
        assert (Character.isJavaIdentifierStart(name.charAt(0))) : "parameter name should be valid java identifier: " + name + ". The first character is invalid.";
        this.modifier = modifier;
        this.name = name;
    }

    public Expression accept(Visitor visitor) {
        return visitor.visit(this);
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.peek(this);
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append(this.name);
    }

    String declString() {
        return this.declString(this.type);
    }

    String declString(Type type) {
        String modifiers = Modifier.toString(this.modifier);
        return modifiers + (modifiers.isEmpty() ? "" : " ") + Types.className(type) + " " + this.name;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

