/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends Statement {
    public final List<DeclarationStatement> declarations;
    public final Expression condition;
    public final Expression post;
    public final Statement body;
    private int hash;

    public ForStatement(List<DeclarationStatement> declarations, Expression condition, Expression post, Statement body) {
        super(ExpressionType.For, Void.TYPE);
        assert (declarations != null);
        assert (body != null);
        this.declarations = declarations;
        this.condition = condition;
        this.post = post;
        this.body = body;
    }

    @Override
    public ForStatement accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        List<DeclarationStatement> decls1 = Expressions.acceptDeclarations(this.declarations, visitor);
        Expression condition1 = this.condition == null ? null : this.condition.accept(visitor);
        Expression post1 = this.post == null ? null : this.post.accept(visitor);
        Statement body1 = this.body.accept(visitor);
        return visitor.visit(this, decls1, condition1, post1, body1);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("for (");
        for (Ord<DeclarationStatement> declaration : Ord.zip(this.declarations)) {
            ((DeclarationStatement)declaration.e).accept2(writer, declaration.i == 0);
        }
        writer.append("; ");
        if (this.condition != null) {
            writer.append(this.condition);
        }
        writer.append("; ");
        if (this.post != null) {
            writer.append(this.post);
        }
        writer.append(") ").append(Blocks.toBlock(this.body));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForStatement that = (ForStatement)o;
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (!this.declarations.equals(that.declarations)) {
            return false;
        }
        return !(this.post != null ? !this.post.equals(that.post) : that.post != null);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = super.hashCode();
            result = 31 * result + this.declarations.hashCode();
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
            if ((result = 31 * result + this.body.hashCode()) == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

