/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.parquet.hadoop.MemoryManager;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;

public class ParquetRecordWriter<T>
extends RecordWriter<Void, T> {
    private InternalParquetRecordWriter<T> internalWriter;
    private MemoryManager memoryManager;

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, int blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) {
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, pageSize, compressor, dictionaryPageSize, enableDictionary, validating, writerVersion, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, MemoryManager memoryManager) {
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, pageSize, compressor, dictionaryPageSize, enableDictionary, validating, writerVersion, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.memoryManager = (MemoryManager)Preconditions.checkNotNull((Object)memoryManager, (String)"memoryManager");
        memoryManager.addWriter(this.internalWriter, blockSize);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.internalWriter.close();
        if (this.memoryManager != null) {
            this.memoryManager.removeWriter(this.internalWriter);
        }
    }

    public void write(Void key, T value) throws IOException, InterruptedException {
        this.internalWriter.write(value);
    }
}

