/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.util;

import java.util.ArrayList;
import java.util.List;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.shaded.com.google.common.base.Functions;
import org.kududb.client.shaded.com.google.common.base.Joiner;
import org.kududb.client.shaded.com.google.common.base.Splitter;
import org.kududb.client.shaded.com.google.common.collect.Iterables;
import org.kududb.client.shaded.com.google.common.collect.Lists;
import org.kududb.client.shaded.com.google.common.net.HostAndPort;

@InterfaceAudience.Private
public class NetUtil {
    public static String hostsAndPortsToString(List<HostAndPort> hostsAndPorts) {
        return Joiner.on(",").join(Lists.transform(hostsAndPorts, Functions.toStringFunction()));
    }

    public static HostAndPort parseString(String addrString, int defaultPort) {
        return addrString.indexOf(58) == -1 ? HostAndPort.fromParts(addrString, defaultPort) : HostAndPort.fromString(addrString);
    }

    public static List<HostAndPort> parseStrings(String commaSepAddrs, int defaultPort) {
        Iterable<String> addrStrings = Splitter.on(',').trimResults().split(commaSepAddrs);
        ArrayList<HostAndPort> hostsAndPorts = Lists.newArrayListWithCapacity(Iterables.size(addrStrings));
        for (String addrString : addrStrings) {
            HostAndPort hostAndPort = NetUtil.parseString(addrString, defaultPort);
            hostsAndPorts.add(hostAndPort);
        }
        return hostsAndPorts;
    }
}

