/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client.shaded.com.google.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import org.kududb.client.shaded.com.google.common.annotations.GwtCompatible;
import org.kududb.client.shaded.com.google.common.collect.ImmutableCollection;
import org.kududb.client.shaded.com.google.common.collect.ImmutableList;
import org.kududb.client.shaded.com.google.common.collect.ImmutableMap;
import org.kududb.client.shaded.com.google.common.collect.ImmutableSet;
import org.kududb.client.shaded.com.google.common.collect.Maps;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableMap<K, V>
extends ImmutableMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    private transient Map.Entry<K, V> entry;

    SingletonImmutableMap(K singleKey, V singleValue) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
    }

    SingletonImmutableMap(Map.Entry<K, V> entry) {
        this.entry = entry;
        this.singleKey = entry.getKey();
        this.singleValue = entry.getValue();
    }

    private Map.Entry<K, V> entry() {
        Map.Entry<K, V> e = this.entry;
        return e == null ? (this.entry = Maps.immutableEntry(this.singleKey, this.singleValue)) : e;
    }

    @Override
    public V get(@Nullable Object key) {
        return this.singleKey.equals(key) ? (V)this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(this.entry());
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return ImmutableList.of(this.singleValue);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map that = (Map)object;
            if (that.size() != 1) {
                return false;
            }
            Map.Entry entry = that.entrySet().iterator().next();
            return this.singleKey.equals(entry.getKey()) && this.singleValue.equals(entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.singleKey.hashCode() ^ this.singleValue.hashCode();
    }

    @Override
    public String toString() {
        return '{' + this.singleKey.toString() + '=' + this.singleValue.toString() + '}';
    }
}

