/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.Iterator;
import org.kududb.Schema;
import org.kududb.WireProtocol;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpcResponse;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.RowResult;
import org.kududb.util.Slice;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowResultIterator
extends KuduRpcResponse
implements Iterator<RowResult>,
Iterable<RowResult> {
    private final Schema schema;
    private final Slice bs;
    private final Slice indirectBs;
    private final int numRows;
    private final RowResult rowResult;
    private int currentRow = 0;

    RowResultIterator(long ellapsedMillis, String tsUUID, Schema schema, WireProtocol.RowwiseRowBlockPB data, CallResponse callResponse) {
        super(ellapsedMillis, tsUUID);
        this.schema = schema;
        if (data == null || data.getNumRows() == 0) {
            this.indirectBs = null;
            this.bs = null;
            this.rowResult = null;
            this.numRows = 0;
            return;
        }
        this.bs = callResponse.getSidecar(data.getRowsSidecar());
        this.indirectBs = callResponse.getSidecar(data.getIndirectDataSidecar());
        this.numRows = data.getNumRows();
        int rowSize = schema.getRowSize();
        int expectedSize = this.numRows * rowSize;
        if (expectedSize != this.bs.length()) {
            throw new NonRecoverableException("RowResult block has " + this.bs.length() + " bytes of data " + "but expected " + expectedSize + " for " + this.numRows + " rows");
        }
        this.rowResult = new RowResult(this.schema, this.bs, this.indirectBs);
    }

    @Override
    public boolean hasNext() {
        return this.currentRow < this.numRows;
    }

    @Override
    public RowResult next() {
        this.rowResult.advancePointer();
        ++this.currentRow;
        return this.rowResult;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public String toString() {
        return "RowResultIterator for " + this.numRows + " rows";
    }

    @Override
    public Iterator<RowResult> iterator() {
        return this;
    }
}

