/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.ListTablesResponse;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class ListTablesRequest
extends KuduRpc<ListTablesResponse> {
    private final String nameFilter;

    ListTablesRequest(KuduTable masterTable, String nameFilter) {
        super(masterTable);
        this.nameFilter = nameFilter;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.ListTablesRequestPB.Builder builder = Master.ListTablesRequestPB.newBuilder();
        if (this.nameFilter != null) {
            builder.setNameFilter(this.nameFilter);
        }
        return ListTablesRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "ListTables";
    }

    @Override
    Pair<ListTablesResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.ListTablesResponsePB.Builder respBuilder = Master.ListTablesResponsePB.newBuilder();
        ListTablesRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        int serversCount = respBuilder.getTablesCount();
        ArrayList<String> tables = new ArrayList<String>(serversCount);
        for (Master.ListTablesResponsePB.TableInfo info : respBuilder.getTablesList()) {
            tables.add(info.getName());
        }
        ListTablesResponse response = new ListTablesResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, tables);
        return new Pair<ListTablesResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

