/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Deferred;
import java.util.List;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AsyncKuduSession;
import org.kududb.client.ExternalConsistencyMode;
import org.kududb.client.Operation;
import org.kududb.client.OperationResponse;
import org.kududb.client.PleaseThrottleException;
import org.kududb.client.SessionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduSession
implements SessionConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(KuduSession.class);
    private final AsyncKuduSession session;

    KuduSession(AsyncKuduSession session) {
        this.session = session;
    }

    public OperationResponse apply(Operation operation) throws Exception {
        while (true) {
            try {
                Deferred<OperationResponse> d = this.session.apply(operation);
                if (this.getFlushMode() == SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC) {
                    return (OperationResponse)d.join(this.getTimeoutMillis());
                }
            }
            catch (PleaseThrottleException ex) {
                try {
                    ex.getDeferred().join(this.getTimeoutMillis());
                }
                catch (Exception e) {
                    LOG.error("Previous batch had this exception", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                throw e;
            }
            break;
        }
        return null;
    }

    public List<OperationResponse> flush() throws Exception {
        return (List)this.session.flush().join(this.getTimeoutMillis());
    }

    public List<OperationResponse> close() throws Exception {
        return (List)this.session.close().join(this.getTimeoutMillis());
    }

    @Override
    public SessionConfiguration.FlushMode getFlushMode() {
        return this.session.getFlushMode();
    }

    @Override
    public void setFlushMode(SessionConfiguration.FlushMode flushMode) {
        this.session.setFlushMode(flushMode);
    }

    @Override
    public void setMutationBufferSpace(int size) {
        this.session.setMutationBufferSpace(size);
    }

    @Override
    public void setMutationBufferLowWatermark(float mutationBufferLowWatermarkPercentage) {
        this.session.setMutationBufferLowWatermark(mutationBufferLowWatermarkPercentage);
    }

    @Override
    public void setFlushInterval(int interval) {
        this.session.setFlushInterval(interval);
    }

    @Override
    public long getTimeoutMillis() {
        return this.session.getTimeoutMillis();
    }

    @Override
    public void setTimeoutMillis(long timeout) {
        this.session.setTimeoutMillis(timeout);
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public boolean hasPendingOperations() {
        return this.session.hasPendingOperations();
    }

    @Override
    public void setExternalConsistencyMode(ExternalConsistencyMode consistencyMode) {
        this.session.setExternalConsistencyMode(consistencyMode);
    }

    @Override
    public boolean isIgnoreAllDuplicateRows() {
        return this.session.isIgnoreAllDuplicateRows();
    }

    @Override
    public void setIgnoreAllDuplicateRows(boolean ignoreAllDuplicateRows) {
        this.session.setIgnoreAllDuplicateRows(ignoreAllDuplicateRows);
    }
}

