/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Deferred;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AbstractKuduScannerBuilder;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.AsyncKuduScanner;
import org.kududb.client.KuduTable;
import org.kududb.client.RowResultIterator;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduScanner {
    private final AsyncKuduScanner asyncScanner;

    KuduScanner(AsyncKuduScanner asyncScanner) {
        this.asyncScanner = asyncScanner;
    }

    public boolean hasMoreRows() {
        return this.asyncScanner.hasMoreRows();
    }

    public RowResultIterator nextRows() throws Exception {
        Deferred<RowResultIterator> d = this.asyncScanner.nextRows();
        return (RowResultIterator)d.join(this.asyncScanner.scanRequestTimeout);
    }

    public RowResultIterator close() throws Exception {
        Deferred<RowResultIterator> d = this.asyncScanner.close();
        return (RowResultIterator)d.join(this.asyncScanner.scanRequestTimeout);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class KuduScannerBuilder
    extends AbstractKuduScannerBuilder<KuduScannerBuilder, KuduScanner> {
        KuduScannerBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
        }

        @Override
        public KuduScanner build() {
            return new KuduScanner(new AsyncKuduScanner(this.client, this.table, this.projectedColumnNames, this.projectedColumnIndexes, this.readMode, this.scanRequestTimeout, this.columnRangePredicates, this.limit, this.cacheBlocks, this.prefetching, this.lowerBoundPrimaryKey, this.upperBoundPrimaryKey, this.lowerBoundPartitionKey, this.upperBoundPartitionKey, this.htTimestamp, this.batchSizeBytes));
        }
    }
}

