/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Deferred;
import java.io.IOException;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.Bytes;
import org.kududb.client.CallResponse;
import org.kududb.client.DeadlineTracker;
import org.kududb.client.ExternalConsistencyMode;
import org.kududb.client.IPCUtil;
import org.kududb.client.InvalidResponseException;
import org.kududb.client.KuduTable;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.shaded.com.google.protobuf.CodedOutputStream;
import org.kududb.client.shaded.com.google.protobuf.GeneratedMessage;
import org.kududb.client.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.kududb.util.Pair;
import org.kududb.util.Slice;

@InterfaceAudience.Private
public abstract class KuduRpc<R> {
    protected static final String MASTER_SERVICE_NAME = "kudu.master.MasterService";
    protected static final String TABLET_SERVER_SERVICE_NAME = "kudu.tserver.TabletServerService";
    private Deferred<R> deferred;
    private AsyncKuduClient.RemoteTablet tablet;
    final KuduTable table;
    final DeadlineTracker deadlineTracker;
    protected long propagatedTimestamp = -1L;
    protected ExternalConsistencyMode externalConsistencyMode = ExternalConsistencyMode.CLIENT_PROPAGATED;
    byte attempt;
    static final long MAX_BYTE_ARRAY_MASK = -268435456L;

    KuduRpc(KuduTable table) {
        this.table = table;
        this.deadlineTracker = new DeadlineTracker();
    }

    abstract ChannelBuffer serialize(Message var1);

    abstract String serviceName();

    abstract String method();

    abstract Pair<R, Object> deserialize(CallResponse var1, String var2) throws Exception;

    public void setExternalConsistencyMode(ExternalConsistencyMode externalConsistencyMode) {
        this.externalConsistencyMode = externalConsistencyMode;
    }

    public ExternalConsistencyMode getExternalConsistencyMode() {
        return this.externalConsistencyMode;
    }

    public void setPropagatedTimestamp(long propagatedTimestamp) {
        this.propagatedTimestamp = propagatedTimestamp;
    }

    private void handleCallback(Object result) {
        Deferred<R> d = this.deferred;
        if (d == null) {
            return;
        }
        this.deferred = null;
        this.attempt = 0;
        this.deadlineTracker.reset();
        d.callback(result);
    }

    final void callback(R result) {
        this.handleCallback(result);
    }

    final void errback(Exception e) {
        this.handleCallback(e);
    }

    final Deferred<R> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    AsyncKuduClient.RemoteTablet getTablet() {
        return this.tablet;
    }

    void setTablet(AsyncKuduClient.RemoteTablet tablet) {
        this.tablet = tablet;
    }

    public KuduTable getTable() {
        return this.table;
    }

    void setTimeoutMillis(long timeout) {
        this.deadlineTracker.setDeadline(timeout);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("KuduRpc(method=");
        buf.append(this.method());
        buf.append(", tablet=");
        if (this.tablet == null) {
            buf.append("null");
        } else {
            buf.append(this.tablet.getTabletIdAsString());
        }
        buf.append(", attempt=").append(this.attempt);
        buf.append(", ").append(this.deadlineTracker);
        buf.append(", ").append(this.deferred);
        buf.append(')');
        return buf.toString();
    }

    static void readProtobuf(Slice slice, GeneratedMessage.Builder<?> builder) {
        int length = slice.length();
        byte[] payload = slice.getRawArray();
        int offset = slice.getRawOffset();
        try {
            builder.mergeFrom(payload, offset, length);
            if (!builder.isInitialized()) {
                throw new InvalidResponseException("Could not deserialize the response, incompatible RPC? Error is: " + builder.getInitializationErrorString(), null);
            }
        }
        catch (InvalidProtocolBufferException e) {
            String msg = "Invalid RPC response: length=" + length + ", payload=" + Bytes.pretty(payload);
            throw new InvalidResponseException(msg, e);
        }
    }

    static ChannelBuffer toChannelBuffer(Message header, Message pb) {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, pb);
        byte[] buf = new byte[totalSize + 4];
        ChannelBuffer chanBuf = ChannelBuffers.wrappedBuffer(buf);
        chanBuf.clear();
        chanBuf.writeInt(totalSize);
        CodedOutputStream out = CodedOutputStream.newInstance(buf, 4, totalSize);
        try {
            out.writeRawVarint32(header.getSerializedSize());
            header.writeTo(out);
            out.writeRawVarint32(pb.getSerializedSize());
            pb.writeTo(out);
            out.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new NonRecoverableException("Cannot serialize the following message " + pb, e);
        }
        chanBuf.writerIndex(buf.length);
        return chanBuf;
    }

    static void checkArrayLength(ChannelBuffer buf, long length) {
        if ((length & 0xFFFFFFFFF0000000L) != 0L) {
            if (length < 0L) {
                throw new IllegalArgumentException("Read negative byte array length: " + length + " in buf=" + buf + '=' + Bytes.pretty(buf));
            }
            throw new IllegalArgumentException("Read byte array length that's too large: " + length + " > " + 0xFFFFFFFL + " in buf=" + buf + '=' + Bytes.pretty(buf));
        }
    }

    public static interface HasKey {
        public byte[] partitionKey();
    }
}

