/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.List;
import org.kududb.Schema;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AlterTableOptions;
import org.kududb.client.AlterTableResponse;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.AsyncKuduSession;
import org.kududb.client.CreateTableOptions;
import org.kududb.client.DeleteTableResponse;
import org.kududb.client.IsAlterTableDoneResponse;
import org.kududb.client.KuduScanner;
import org.kududb.client.KuduSession;
import org.kududb.client.KuduTable;
import org.kududb.client.ListTablesResponse;
import org.kududb.client.ListTabletServersResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduClient
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(AsyncKuduClient.class);
    private final AsyncKuduClient asyncClient;

    KuduClient(AsyncKuduClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public KuduTable createTable(String name, Schema schema) throws Exception {
        return this.createTable(name, schema, new CreateTableOptions());
    }

    public KuduTable createTable(String name, Schema schema, CreateTableOptions builder) throws Exception {
        Deferred<KuduTable> d = this.asyncClient.createTable(name, schema, builder);
        return (KuduTable)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public DeleteTableResponse deleteTable(String name) throws Exception {
        Deferred<DeleteTableResponse> d = this.asyncClient.deleteTable(name);
        return (DeleteTableResponse)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public AlterTableResponse alterTable(String name, AlterTableOptions ato) throws Exception {
        Deferred<AlterTableResponse> d = this.asyncClient.alterTable(name, ato);
        return (AlterTableResponse)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public boolean isAlterTableDone(String name) throws Exception {
        long totalSleepTime = 0L;
        while (totalSleepTime < this.getDefaultAdminOperationTimeoutMs()) {
            long start = System.currentTimeMillis();
            Deferred<IsAlterTableDoneResponse> d = this.asyncClient.isAlterTableDone(name);
            IsAlterTableDoneResponse response = (IsAlterTableDoneResponse)d.join(500L);
            if (response.isDone()) {
                return true;
            }
            long elapsed = System.currentTimeMillis() - start;
            if (totalSleepTime + 500L > this.getDefaultAdminOperationTimeoutMs()) {
                return false;
            }
            if (elapsed <= 500L) {
                LOG.debug("Alter not done, sleep " + (500L - elapsed) + " and slept " + totalSleepTime);
                Thread.sleep(500L - elapsed);
                totalSleepTime += 500L;
                continue;
            }
            totalSleepTime += elapsed;
        }
        return false;
    }

    public ListTabletServersResponse listTabletServers() throws Exception {
        Deferred<ListTabletServersResponse> d = this.asyncClient.listTabletServers();
        return (ListTabletServersResponse)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public ListTablesResponse getTablesList() throws Exception {
        return this.getTablesList(null);
    }

    public ListTablesResponse getTablesList(String nameFilter) throws Exception {
        Deferred<ListTablesResponse> d = this.asyncClient.getTablesList(nameFilter);
        return (ListTablesResponse)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public boolean tableExists(String name) throws Exception {
        Deferred<Boolean> d = this.asyncClient.tableExists(name);
        return (Boolean)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public KuduTable openTable(String name) throws Exception {
        Deferred<KuduTable> d = this.asyncClient.openTable(name);
        return (KuduTable)d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public KuduSession newSession() {
        AsyncKuduSession session = this.asyncClient.newSession();
        return new KuduSession(session);
    }

    public KuduScanner.KuduScannerBuilder newScannerBuilder(KuduTable table) {
        return new KuduScanner.KuduScannerBuilder(this.asyncClient, table);
    }

    @Override
    public void close() throws Exception {
        this.asyncClient.close();
    }

    public void shutdown() throws Exception {
        Deferred<ArrayList<Void>> d = this.asyncClient.shutdown();
        d.join(this.getDefaultAdminOperationTimeoutMs());
    }

    public long getDefaultOperationTimeoutMs() {
        return this.asyncClient.getDefaultOperationTimeoutMs();
    }

    public long getDefaultAdminOperationTimeoutMs() {
        return this.asyncClient.getDefaultAdminOperationTimeoutMs();
    }

    public static final class KuduClientBuilder {
        private AsyncKuduClient.AsyncKuduClientBuilder clientBuilder;

        public KuduClientBuilder(String masterAddresses) {
            this.clientBuilder = new AsyncKuduClient.AsyncKuduClientBuilder(masterAddresses);
        }

        public KuduClientBuilder(List<String> masterAddresses) {
            this.clientBuilder = new AsyncKuduClient.AsyncKuduClientBuilder(masterAddresses);
        }

        public KuduClientBuilder defaultAdminOperationTimeoutMs(long timeoutMs) {
            this.clientBuilder.defaultAdminOperationTimeoutMs(timeoutMs);
            return this;
        }

        public KuduClientBuilder defaultOperationTimeoutMs(long timeoutMs) {
            this.clientBuilder.defaultOperationTimeoutMs(timeoutMs);
            return this;
        }

        public KuduClientBuilder defaultSocketReadTimeoutMs(long timeoutMs) {
            this.clientBuilder.defaultSocketReadTimeoutMs(timeoutMs);
            return this;
        }

        public KuduClient build() {
            AsyncKuduClient client = this.clientBuilder.build();
            return new KuduClient(client);
        }
    }
}

