/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.Bytes;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.shaded.com.google.protobuf.ByteString;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class GetTableLocationsRequest
extends KuduRpc<Master.GetTableLocationsResponsePB> {
    private final byte[] startPartitionKey;
    private final byte[] endKey;
    private final String tableId;

    GetTableLocationsRequest(KuduTable table, byte[] startPartitionKey, byte[] endPartitionKey, String tableId) {
        super(table);
        if (startPartitionKey != null && endPartitionKey != null && Bytes.memcmp(startPartitionKey, endPartitionKey) > 0) {
            throw new IllegalArgumentException("The start partition key must be smaller or equal to the end partition key");
        }
        this.startPartitionKey = startPartitionKey;
        this.endKey = endPartitionKey;
        this.tableId = tableId;
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "GetTableLocations";
    }

    @Override
    Pair<Master.GetTableLocationsResponsePB, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.GetTableLocationsResponsePB.Builder builder = Master.GetTableLocationsResponsePB.newBuilder();
        GetTableLocationsRequest.readProtobuf(callResponse.getPBMessage(), builder);
        Master.GetTableLocationsResponsePB resp = builder.build();
        return new Pair<Master.GetTableLocationsResponsePB, Object>(resp, builder.hasError() ? builder.getError() : null);
    }

    @Override
    ChannelBuffer serialize(Message header) {
        Master.GetTableLocationsRequestPB.Builder builder = Master.GetTableLocationsRequestPB.newBuilder();
        builder.setTable(Master.TableIdentifierPB.newBuilder().setTableId(ByteString.copyFromUtf8(this.tableId)));
        if (this.startPartitionKey != null) {
            builder.setPartitionKeyStart(ZeroCopyLiteralByteString.wrap(this.startPartitionKey));
        }
        if (this.endKey != null) {
            builder.setPartitionKeyEnd(ZeroCopyLiteralByteString.wrap(this.endKey));
        }
        return GetTableLocationsRequest.toChannelBuffer(header, builder.build());
    }
}

