/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.kududb.Common;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.GetMasterRegistrationResponse;
import org.kududb.client.NoLeaderMasterFoundException;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.shaded.com.google.common.net.HostAndPort;
import org.kududb.client.shaded.com.google.protobuf.ByteString;
import org.kududb.consensus.Metadata;
import org.kududb.master.Master;
import org.kududb.util.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class GetMasterRegistrationReceived {
    private static final Logger LOG = LoggerFactory.getLogger(GetMasterRegistrationReceived.class);
    private final List<HostAndPort> masterAddrs;
    private final Deferred<Master.GetTableLocationsResponsePB> responseD;
    private final int numMasters;
    private final AtomicBoolean responseDCalled = new AtomicBoolean(false);
    private final AtomicInteger countResponsesReceived = new AtomicInteger(0);
    private final List<Exception> exceptionsReceived = Collections.synchronizedList(new ArrayList());

    public GetMasterRegistrationReceived(List<HostAndPort> masterAddrs, Deferred<Master.GetTableLocationsResponsePB> responseD) {
        this.masterAddrs = masterAddrs;
        this.responseD = responseD;
        this.numMasters = masterAddrs.size();
    }

    public Callback<Void, GetMasterRegistrationResponse> callbackForNode(HostAndPort hostAndPort) {
        return new GetMasterRegistrationCB(hostAndPort);
    }

    public Callback<Void, Exception> errbackForNode(HostAndPort hostAndPort) {
        return new GetMasterRegistrationErrCB(hostAndPort);
    }

    private void incrementCountAndCheckExhausted() {
        if (this.countResponsesReceived.incrementAndGet() == this.numMasters && this.responseDCalled.compareAndSet(false, true)) {
            boolean allUnrecoverable = true;
            for (Exception ex : this.exceptionsReceived) {
                if (ex instanceof NonRecoverableException) continue;
                allUnrecoverable = false;
                break;
            }
            String allHosts = NetUtil.hostsAndPortsToString(this.masterAddrs);
            if (!allUnrecoverable) {
                if (this.exceptionsReceived.isEmpty()) {
                    LOG.warn("None of the provided masters (" + allHosts + ") is a leader, will retry.");
                } else {
                    LOG.warn("Unable to find the leader master (" + allHosts + "), will retry");
                }
                this.responseD.callback((Object)NoLeaderMasterFoundException.create("Master config (" + allHosts + ") has no leader.", this.exceptionsReceived));
            } else {
                this.responseD.callback((Object)new NonRecoverableException("Couldn't find a valid master in (" + allHosts + "), exceptions: " + this.exceptionsReceived));
            }
        }
    }

    final class GetMasterRegistrationErrCB
    implements Callback<Void, Exception> {
        private final HostAndPort hostAndPort;

        public GetMasterRegistrationErrCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public Void call(Exception e) throws Exception {
            LOG.warn("Error receiving a response from: " + this.hostAndPort, (Throwable)e);
            GetMasterRegistrationReceived.this.exceptionsReceived.add(e);
            GetMasterRegistrationReceived.this.incrementCountAndCheckExhausted();
            return null;
        }

        public String toString() {
            return "get master registration errback for " + this.hostAndPort.toString();
        }
    }

    final class GetMasterRegistrationCB
    implements Callback<Void, GetMasterRegistrationResponse> {
        private final HostAndPort hostAndPort;

        public GetMasterRegistrationCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public Void call(GetMasterRegistrationResponse r) throws Exception {
            Master.TabletLocationsPB.ReplicaPB.Builder replicaBuilder = Master.TabletLocationsPB.ReplicaPB.newBuilder();
            Master.TSInfoPB.Builder tsInfoBuilder = Master.TSInfoPB.newBuilder();
            tsInfoBuilder.addRpcAddresses(ProtobufHelper.hostAndPortToPB(this.hostAndPort));
            tsInfoBuilder.setPermanentUuid(r.getInstanceId().getPermanentUuid());
            replicaBuilder.setTsInfo(tsInfoBuilder);
            if (r.getRole().equals(Metadata.RaftPeerPB.Role.LEADER)) {
                replicaBuilder.setRole(r.getRole());
                Master.TabletLocationsPB.Builder locationBuilder = Master.TabletLocationsPB.newBuilder();
                locationBuilder.setPartition(Common.PartitionPB.newBuilder().setPartitionKeyStart(ByteString.EMPTY).setPartitionKeyEnd(ByteString.EMPTY));
                locationBuilder.setTabletId(ByteString.copyFromUtf8("Kudu Master"));
                locationBuilder.setStale(false);
                locationBuilder.addReplicas(replicaBuilder);
                if (GetMasterRegistrationReceived.this.responseDCalled.compareAndSet(false, true)) {
                    GetMasterRegistrationReceived.this.responseD.callback((Object)Master.GetTableLocationsResponsePB.newBuilder().addTabletLocations(locationBuilder.build()).build());
                } else {
                    LOG.debug("Callback already invoked, discarding response(" + r.toString() + ") from " + this.hostAndPort.toString());
                }
            } else {
                GetMasterRegistrationReceived.this.incrementCountAndCheckExhausted();
            }
            return null;
        }

        public String toString() {
            return "get master registration for " + this.hostAndPort.toString();
        }
    }
}

