/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import org.kududb.Schema;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.CallResponse;
import org.kududb.client.CreateTableOptions;
import org.kududb.client.CreateTableResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.master.Master;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class CreateTableRequest
extends KuduRpc<CreateTableResponse> {
    static final String CREATE_TABLE = "CreateTable";
    private final Schema schema;
    private final String name;
    private final Master.CreateTableRequestPB.Builder builder;

    CreateTableRequest(KuduTable masterTable, String name, Schema schema, CreateTableOptions builder) {
        super(masterTable);
        this.schema = schema;
        this.name = name;
        this.builder = builder.getBuilder();
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        this.builder.setName(this.name);
        this.builder.setSchema(ProtobufHelper.schemaToPb(this.schema));
        return CreateTableRequest.toChannelBuffer(header, this.builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return CREATE_TABLE;
    }

    @Override
    Pair<CreateTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.CreateTableResponsePB.Builder builder = Master.CreateTableResponsePB.newBuilder();
        CreateTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        CreateTableResponse response = new CreateTableResponse(this.deadlineTracker.getElapsedMillis(), tsUUID);
        return new Pair<CreateTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }
}

