/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kududb.ColumnSchema;
import org.kududb.Type;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.Bytes;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.kududb.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.kududb.tserver.Tserver;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ColumnRangePredicate {
    private final Tserver.ColumnRangePredicatePB.Builder pb = Tserver.ColumnRangePredicatePB.newBuilder();
    private final ColumnSchema column;
    private byte[] lowerBound = null;
    private byte[] upperBound = null;

    public ColumnRangePredicate(ColumnSchema column) {
        this.column = column;
        this.pb.setColumn(ProtobufHelper.columnToPb(column));
    }

    private void setLowerBoundInternal(byte[] value) {
        this.lowerBound = value;
        this.pb.setLowerBound(ZeroCopyLiteralByteString.wrap(this.lowerBound));
    }

    private void setUpperBoundInternal(byte[] value) {
        this.upperBound = value;
        this.pb.setUpperBound(ZeroCopyLiteralByteString.wrap(this.upperBound));
    }

    public void setLowerBound(boolean lowerBound) {
        this.checkColumn(Type.BOOL);
        this.setLowerBoundInternal(Bytes.fromBoolean(lowerBound));
    }

    public void setLowerBound(byte lowerBound) {
        this.checkColumn(Type.INT8);
        this.setLowerBoundInternal(new byte[]{lowerBound});
    }

    public void setLowerBound(short lowerBound) {
        this.checkColumn(Type.INT16);
        this.setLowerBoundInternal(Bytes.fromShort(lowerBound));
    }

    public void setLowerBound(int lowerBound) {
        this.checkColumn(Type.INT32);
        this.setLowerBoundInternal(Bytes.fromInt(lowerBound));
    }

    public void setLowerBound(long lowerBound) {
        this.checkColumn(Type.INT64, Type.TIMESTAMP);
        this.setLowerBoundInternal(Bytes.fromLong(lowerBound));
    }

    public void setLowerBound(String lowerBound) {
        this.checkColumn(Type.STRING);
        this.setLowerBoundInternal(lowerBound.getBytes());
    }

    public void setLowerBound(byte[] lowerBound) {
        this.checkColumn(Type.BINARY);
        this.setLowerBoundInternal(lowerBound);
    }

    public void setLowerBound(float lowerBound) {
        this.checkColumn(Type.FLOAT);
        this.setLowerBoundInternal(Bytes.fromFloat(lowerBound));
    }

    public void setLowerBound(double lowerBound) {
        this.checkColumn(Type.DOUBLE);
        this.setLowerBoundInternal(Bytes.fromDouble(lowerBound));
    }

    public void setUpperBound(boolean upperBound) {
        this.checkColumn(Type.BOOL);
        this.setUpperBoundInternal(Bytes.fromBoolean(upperBound));
    }

    public void setUpperBound(byte upperBound) {
        this.checkColumn(Type.INT8);
        this.setUpperBoundInternal(new byte[]{upperBound});
    }

    public void setUpperBound(short upperBound) {
        this.checkColumn(Type.INT16);
        this.setUpperBoundInternal(Bytes.fromShort(upperBound));
    }

    public void setUpperBound(int upperBound) {
        this.checkColumn(Type.INT32);
        this.setUpperBoundInternal(Bytes.fromInt(upperBound));
    }

    public void setUpperBound(long upperBound) {
        this.checkColumn(Type.INT64, Type.TIMESTAMP);
        this.setUpperBoundInternal(Bytes.fromLong(upperBound));
    }

    public void setUpperBound(String upperBound) {
        this.checkColumn(Type.STRING);
        this.setUpperBoundInternal(upperBound.getBytes());
    }

    public void setUpperBound(byte[] upperBound) {
        this.checkColumn(Type.BINARY);
        this.setUpperBoundInternal(upperBound);
    }

    public void setUpperBound(float upperBound) {
        this.checkColumn(Type.FLOAT);
        this.setUpperBoundInternal(Bytes.fromFloat(upperBound));
    }

    public void setUpperBound(double upperBound) {
        this.checkColumn(Type.DOUBLE);
        this.setUpperBoundInternal(Bytes.fromDouble(upperBound));
    }

    public ColumnSchema getColumn() {
        return this.column;
    }

    public byte[] getLowerBound() {
        return this.lowerBound;
    }

    public byte[] getUpperBound() {
        return this.upperBound;
    }

    public static byte[] toByteArray(List<ColumnRangePredicate> predicates) {
        if (predicates.isEmpty()) {
            return null;
        }
        Tserver.ColumnRangePredicateListPB.Builder predicateListBuilder = Tserver.ColumnRangePredicateListPB.newBuilder();
        for (ColumnRangePredicate crp : predicates) {
            predicateListBuilder.addRangePredicates(crp.getPb());
        }
        return predicateListBuilder.build().toByteArray();
    }

    static List<Tserver.ColumnRangePredicatePB> fromByteArray(byte[] listBytes) {
        ArrayList<Tserver.ColumnRangePredicatePB> predicates = new ArrayList<Tserver.ColumnRangePredicatePB>();
        if (listBytes == null || listBytes.length == 0) {
            return predicates;
        }
        Tserver.ColumnRangePredicateListPB list = ColumnRangePredicate.getPbFromBytes(listBytes);
        return list.getRangePredicatesList();
    }

    Tserver.ColumnRangePredicatePB getPb() {
        return this.pb.build();
    }

    private static Tserver.ColumnRangePredicateListPB getPbFromBytes(byte[] listBytes) {
        try {
            return Tserver.ColumnRangePredicateListPB.parseFrom(listBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Encountered an invalid column range predicate list: " + Bytes.pretty(listBytes), e);
        }
    }

    private void checkColumn(Type ... passedTypes) {
        for (Type type : passedTypes) {
            if (!this.column.getType().equals((Object)type)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("%s's type isn't %s, it's %s", this.column.getName(), Arrays.toString((Object[])passedTypes), this.column.getType().getName()));
    }
}

