/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kududb.WireProtocol;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.client.BatchResponse;
import org.kududb.client.CallResponse;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.Operation;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.tserver.Tserver;
import org.kududb.util.Pair;

@InterfaceAudience.Private
class Batch
extends KuduRpc<BatchResponse>
implements KuduRpc.HasKey {
    private static final OperationsComparatorBySequenceNumber SEQUENCE_NUMBER_COMPARATOR = new OperationsComparatorBySequenceNumber();
    final List<Operation> ops;
    boolean needsSorting = false;
    final boolean ignoreAllDuplicateRows;

    Batch(KuduTable table, boolean ignoreAllDuplicateRows) {
        this(table, ignoreAllDuplicateRows, 1000);
    }

    Batch(KuduTable table, boolean ignoreAllDuplicateRows, int estimatedBatchSize) {
        super(table);
        this.ops = new ArrayList<Operation>(estimatedBatchSize);
        this.ignoreAllDuplicateRows = ignoreAllDuplicateRows;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        if (this.needsSorting) {
            Collections.sort(this.ops, SEQUENCE_NUMBER_COMPARATOR);
        }
        Tserver.WriteRequestPB.Builder builder = Operation.createAndFillWriteRequestPB(this.ops.toArray(new Operation[this.ops.size()]));
        builder.setTabletId(ZeroCopyLiteralByteString.wrap(this.getTablet().getTabletIdAsBytes()));
        builder.setExternalConsistencyMode(this.externalConsistencyMode.pbVersion());
        return Batch.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return "Write";
    }

    @Override
    Pair<BatchResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Tserver.WriteResponsePB.Builder builder = Tserver.WriteResponsePB.newBuilder();
        Batch.readProtobuf(callResponse.getPBMessage(), builder);
        List<Tserver.WriteResponsePB.PerRowErrorPB> errorsPB = builder.getPerRowErrorsList();
        if (this.ignoreAllDuplicateRows) {
            boolean allAlreadyPresent = true;
            for (Tserver.WriteResponsePB.PerRowErrorPB errorPB : errorsPB) {
                if (errorPB.getError().getCode() == WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT) continue;
                allAlreadyPresent = false;
                break;
            }
            if (allAlreadyPresent) {
                errorsPB = Collections.emptyList();
            }
        }
        BatchResponse response = new BatchResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, builder.getTimestamp(), errorsPB, this.ops);
        return new Pair<BatchResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    public byte[] partitionKey() {
        assert (this.ops.size() > 0);
        return this.ops.get(0).partitionKey();
    }

    private static class OperationsComparatorBySequenceNumber
    implements Comparator<Operation> {
        private OperationsComparatorBySequenceNumber() {
        }

        @Override
        public int compare(Operation o1, Operation o2) {
            return Long.compare(o1.getSequenceNumber(), o2.getSequenceNumber());
        }
    }
}

