/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.Batch;
import org.kududb.client.BatchResponse;
import org.kududb.client.Bytes;
import org.kududb.client.ExternalConsistencyMode;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.Operation;
import org.kududb.client.OperationResponse;
import org.kududb.client.PleaseThrottleException;
import org.kududb.client.SessionConfiguration;
import org.kududb.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.kududb.client.shaded.com.google.common.collect.Range;
import org.kududb.client.shaded.com.google.common.collect.Ranges;
import org.kududb.client.shaded.com.google.common.collect.Sets;
import org.kududb.client.shaded.org.jboss.netty.util.Timeout;
import org.kududb.client.shaded.org.jboss.netty.util.TimerTask;
import org.kududb.master.Master;
import org.kududb.util.Slice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AsyncKuduSession
implements SessionConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(AsyncKuduSession.class);
    private static final Range<Float> PERCENTAGE_RANGE = Ranges.closed(Float.valueOf(0.0f), Float.valueOf(1.0f));
    private final AsyncKuduClient client;
    private final Random randomizer = new Random();
    private int interval = 1000;
    private int mutationBufferSpace = 1000;
    private float mutationBufferLowWatermarkPercentage = 0.5f;
    private int mutationBufferLowWatermark;
    private SessionConfiguration.FlushMode flushMode;
    private ExternalConsistencyMode consistencyMode;
    private long timeoutMs;
    private long nextSequenceNumber = 0L;
    @GuardedBy(value="this")
    private final Map<Slice, Batch> operations = new HashMap<Slice, Batch>();
    @GuardedBy(value="this")
    private final Map<Slice, Deferred<BatchResponse>> operationsInFlight = new HashMap<Slice, Deferred<BatchResponse>>();
    @GuardedBy(value="this")
    private final Set<Operation> operationsInLookup = Sets.newIdentityHashSet();
    private Deferred<Void> lookupsDone;
    volatile boolean closed;
    private boolean ignoreAllDuplicateRows = false;

    AsyncKuduSession(AsyncKuduClient client) {
        this.client = client;
        this.flushMode = SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC;
        this.consistencyMode = ExternalConsistencyMode.CLIENT_PROPAGATED;
        this.timeoutMs = client.getDefaultOperationTimeoutMs();
        this.setMutationBufferLowWatermark(this.mutationBufferLowWatermarkPercentage);
    }

    @Override
    public SessionConfiguration.FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(SessionConfiguration.FlushMode flushMode) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change flush mode when writes are buffered");
        }
        this.flushMode = flushMode;
    }

    @Override
    public void setExternalConsistencyMode(ExternalConsistencyMode consistencyMode) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change consistency mode when writes are buffered");
        }
        this.consistencyMode = consistencyMode;
    }

    @Override
    public void setMutationBufferSpace(int size) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change the buffer size when operations are buffered");
        }
        this.mutationBufferSpace = size;
        this.setMutationBufferLowWatermark(this.mutationBufferLowWatermarkPercentage);
    }

    @Override
    public void setMutationBufferLowWatermark(float mutationBufferLowWatermarkPercentage) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change the buffer low watermark when operations are buffered");
        }
        if (!PERCENTAGE_RANGE.contains(Float.valueOf(mutationBufferLowWatermarkPercentage))) {
            throw new IllegalArgumentException("The low watermark must be between 0 and 1 inclusively");
        }
        this.mutationBufferLowWatermarkPercentage = mutationBufferLowWatermarkPercentage;
        this.mutationBufferLowWatermark = (int)(this.mutationBufferLowWatermarkPercentage * (float)this.mutationBufferSpace);
    }

    @VisibleForTesting
    void setRandomSeed(long seed) {
        this.randomizer.setSeed(seed);
    }

    @Override
    public void setFlushInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public void setTimeoutMillis(long timeout) {
        this.timeoutMs = timeout;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMs;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isIgnoreAllDuplicateRows() {
        return this.ignoreAllDuplicateRows;
    }

    @Override
    public void setIgnoreAllDuplicateRows(boolean ignoreAllDuplicateRows) {
        this.ignoreAllDuplicateRows = ignoreAllDuplicateRows;
    }

    public Deferred<List<OperationResponse>> close() {
        this.closed = true;
        this.client.removeSession(this);
        return this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<List<OperationResponse>> flush() {
        LOG.trace("Flushing all tablets");
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            if (!this.operationsInLookup.isEmpty()) {
                this.lookupsDone = new Deferred();
                return this.lookupsDone.addCallbackDeferring((Callback)new OperationsInLookupDoneCB()).addCallbackDeferring((Callback)new ConvertBatchToListOfResponsesCB());
            }
        }
        return this.flushAllBatches().addCallbackDeferring((Callback)new ConvertBatchToListOfResponsesCB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<ArrayList<BatchResponse>> flushAllBatches() {
        HashMap<Slice, Batch> copyOfOps;
        ArrayList<Deferred<BatchResponse>> d = new ArrayList<Deferred<BatchResponse>>(this.operations.size());
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            copyOfOps = new HashMap<Slice, Batch>(this.operations);
        }
        for (Map.Entry<Slice, Batch> entry : copyOfOps.entrySet()) {
            d.add(this.flushTablet(entry.getKey(), entry.getValue()));
        }
        return Deferred.group(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingOperations() {
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            return !this.operations.isEmpty() || !this.operationsInFlight.isEmpty() || !this.operationsInLookup.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<OperationResponse> apply(Operation operation) {
        byte[] partitionKey;
        String tableId;
        AsyncKuduClient.RemoteTablet tablet;
        if (operation == null) {
            throw new NullPointerException("Cannot apply a null operation");
        }
        if (AsyncKuduClient.cannotRetryRequest(operation)) {
            return AsyncKuduClient.tooManyAttemptsOrTimeout(operation, null);
        }
        operation.getRow().freeze();
        if (this.flushMode == SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC) {
            if (this.timeoutMs != 0L) {
                operation.setTimeoutMillis(this.timeoutMs);
            }
            operation.setExternalConsistencyMode(this.consistencyMode);
            return this.client.sendRpcToTablet(operation);
        }
        if (operation.getSequenceNumber() == -1L) {
            operation.setSequenceNumber(this.nextSequenceNumber++);
        }
        if ((tablet = this.client.getTablet(tableId = operation.getTable().getTableId(), partitionKey = operation.partitionKey())) != null) {
            operation.setTablet(tablet);
            return this.addToBuffer(tablet.getTabletId(), operation);
        }
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            this.operationsInLookup.add(operation);
        }
        operation.attempt = (byte)(operation.attempt + 1);
        if (this.client.isTableNotServed(tableId)) {
            TabletLookupCB<Master.IsCreateTableDoneResponsePB> cb = new TabletLookupCB<Master.IsCreateTableDoneResponsePB>(operation);
            return this.client.delayedIsCreateTableDone(operation.getTable(), operation, cb, this.getOpInLookupErrback(operation));
        }
        Deferred<Master.GetTableLocationsResponsePB> d = this.client.locateTablet(operation.getTable(), partitionKey);
        d.addErrback(this.getOpInLookupErrback(operation));
        return d.addCallbackDeferring(new TabletLookupCB(operation));
    }

    Callback<Exception, Exception> getOpInLookupErrback(final Operation operation) {
        return new Callback<Exception, Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Exception call(Exception e) throws Exception {
                1 var2_2 = this;
                synchronized (var2_2) {
                    AsyncKuduSession.this.operationsInLookup.remove(operation);
                }
                operation.errback(e);
                return e;
            }
        };
    }

    Callback<Deferred<OperationResponse>, Object> getRetryOpInLookupCB(final Operation operation) {
        final class RetryOpInFlightCB
        implements Callback<Deferred<OperationResponse>, Object> {
            RetryOpInFlightCB() {
            }

            public Deferred<OperationResponse> call(Object arg) {
                return AsyncKuduSession.this.handleOperationInLookup(operation);
            }

            public String toString() {
                return "retry RPC after PleaseThrottleException";
            }
        }
        return new RetryOpInFlightCB();
    }

    private Deferred<OperationResponse> handleOperationInLookup(Operation operation) {
        try {
            return this.apply(operation);
        }
        catch (PleaseThrottleException pte) {
            return pte.getDeferred().addBothDeferring(this.getRetryOpInLookupCB(operation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<OperationResponse> addToBuffer(Slice tablet, Operation operation) {
        Batch batch;
        boolean scheduleFlush = false;
        boolean batchIsFull = false;
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            batch = this.operations.get(tablet);
            if (batch != null && batch.ops.size() + 1 > this.mutationBufferSpace) {
                if (this.flushMode == SessionConfiguration.FlushMode.MANUAL_FLUSH) {
                    throw new NonRecoverableException("MANUAL_FLUSH is enabled but the buffer is too big");
                }
                if (this.operationsInFlight.containsKey(tablet)) {
                    throw new PleaseThrottleException("The RPC cannot be buffered because the current buffer is full and the previous buffer hasn't been flushed yet", null, operation, this.operationsInFlight.get(tablet));
                }
                batchIsFull = true;
            }
        }
        if (batchIsFull) {
            this.flushTablet(tablet, batch);
        }
        Deferred<Void> lookupsDoneCopy = null;
        AsyncKuduSession asyncKuduSession2 = this;
        synchronized (asyncKuduSession2) {
            int randomWatermark;
            batch = this.operations.get(tablet);
            if (this.mutationBufferLowWatermark < this.mutationBufferSpace && batch != null && this.operationsInFlight.containsKey(tablet) && batch.ops.size() + 1 > this.mutationBufferLowWatermark && (randomWatermark = batch.ops.size() + 1 + this.randomizer.nextInt(this.mutationBufferSpace - this.mutationBufferLowWatermark)) > this.mutationBufferSpace) {
                throw new PleaseThrottleException("The previous buffer hasn't been flushed and the current one is over the low watermark, please retry later", null, operation, this.operationsInFlight.get(tablet));
            }
            if (batch == null) {
                batch = new Batch(operation.getTable(), this.ignoreAllDuplicateRows);
                batch.setExternalConsistencyMode(this.consistencyMode);
                Batch oldBatch = this.operations.put(tablet, batch);
                assert (oldBatch == null);
                this.addBatchCallbacks(batch);
                scheduleFlush = true;
            }
            batch.ops.add(operation);
            if (!this.operationsInLookup.isEmpty()) {
                boolean operationWasLookingUpTablet = this.operationsInLookup.remove(operation);
                if (operationWasLookingUpTablet) {
                    batch.needsSorting = true;
                }
                if (this.lookupsDone != null && this.operationsInLookup.isEmpty()) {
                    lookupsDoneCopy = this.lookupsDone;
                    this.lookupsDone = null;
                }
            }
            if (this.flushMode == SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND && scheduleFlush) {
                LOG.trace("Scheduling a flush");
                this.scheduleNextPeriodicFlush(tablet, batch);
            }
        }
        if (lookupsDoneCopy != null) {
            lookupsDoneCopy.callback(null);
        }
        return operation.getDeferred();
    }

    private void addBatchCallbacks(final Batch request) {
        final class BatchCallback
        implements Callback<BatchResponse, BatchResponse> {
            BatchCallback() {
            }

            public BatchResponse call(BatchResponse response) {
                LOG.trace("Got a Batch response for " + request.ops.size() + " rows");
                if (response.getWriteTimestamp() != 0L) {
                    AsyncKuduSession.this.client.updateLastPropagatedTimestamp(response.getWriteTimestamp());
                }
                for (OperationResponse operationResponse : response.getIndividualResponses()) {
                    operationResponse.getOperation().callback(operationResponse);
                }
                return response;
            }

            public String toString() {
                return "apply batch response";
            }
        }
        final class BatchErrCallback
        implements Callback<Exception, Exception> {
            BatchErrCallback() {
            }

            public Exception call(Exception e) throws Exception {
                for (int i = 0; i < request.ops.size(); ++i) {
                    request.ops.get(i).errback(e);
                }
                return e;
            }

            public String toString() {
                return "apply batch error response";
            }
        }
        request.getDeferred().addCallbacks((Callback)new BatchCallback(), (Callback)new BatchErrCallback());
    }

    private void scheduleNextPeriodicFlush(Slice tablet, Batch batch) {
        this.client.newTimeout(new FlusherTask(tablet, batch), this.interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<BatchResponse> flushTablet(Slice tablet, Batch expectedBatch) {
        Batch batch;
        assert (expectedBatch != null);
        assert (!Thread.holdsLock(this));
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            if (this.operations.get(tablet) != expectedBatch) {
                LOG.trace("Had to flush a tablet but it was already flushed: " + Bytes.getString(tablet));
                return Deferred.fromResult(null);
            }
            if (this.operationsInFlight.containsKey(tablet)) {
                LOG.trace("This tablet is already in flight, attaching a callback to retry later: " + Bytes.getString(tablet));
                return this.operationsInFlight.get(tablet).addCallbackDeferring((Callback)new FlushRetryCallback(tablet, this.operations.get(tablet)));
            }
            batch = this.operations.remove(tablet);
            if (batch == null) {
                LOG.trace("Had to flush a tablet but there was nothing to flush: " + Bytes.getString(tablet));
                return Deferred.fromResult(null);
            }
            Deferred batchDeferred = batch.getDeferred();
            batchDeferred.addCallbacks(this.getOpInFlightCallback(tablet), this.getOpInFlightErrback(tablet));
            Deferred oldBatch = this.operationsInFlight.put(tablet, batchDeferred);
            assert (oldBatch == null);
            if (this.timeoutMs != 0L) {
                batch.deadlineTracker.reset();
                batch.setTimeoutMillis(this.timeoutMs);
            }
        }
        return this.client.sendRpcToTablet(batch);
    }

    private Callback<BatchResponse, BatchResponse> getOpInFlightCallback(final Slice tablet) {
        return new Callback<BatchResponse, BatchResponse>(){

            public BatchResponse call(BatchResponse o) throws Exception {
                AsyncKuduSession.this.tabletInFlightDone(tablet);
                return o;
            }
        };
    }

    private Callback<Exception, Exception> getOpInFlightErrback(final Slice tablet) {
        return new Callback<Exception, Exception>(){

            public Exception call(Exception e) throws Exception {
                AsyncKuduSession.this.tabletInFlightDone(tablet);
                return e;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tabletInFlightDone(Slice tablet) {
        AsyncKuduSession asyncKuduSession = this;
        synchronized (asyncKuduSession) {
            LOG.trace("Unmarking this tablet as in flight: " + Bytes.getString(tablet));
            this.operationsInFlight.remove(tablet);
        }
    }

    class FlusherTask
    implements TimerTask {
        final Slice tabletSlice;
        final Batch expectedBatch;

        FlusherTask(Slice tabletSlice, Batch expectedBatch) {
            this.tabletSlice = tabletSlice;
            this.expectedBatch = expectedBatch;
        }

        @Override
        public void run(Timeout timeout) {
            if (AsyncKuduSession.this.isClosed()) {
                return;
            }
            LOG.trace("Timed flushing: " + Bytes.getString(this.tabletSlice));
            AsyncKuduSession.this.flushTablet(this.tabletSlice, this.expectedBatch);
        }

        public String toString() {
            return "flush commits of session " + AsyncKuduSession.this + " for tabletSlice " + Bytes.getString(this.tabletSlice);
        }
    }

    class FlushRetryCallback
    implements Callback<Deferred<BatchResponse>, BatchResponse> {
        private final Slice tablet;
        private final Batch expectedBatch;

        public FlushRetryCallback(Slice tablet, Batch expectedBatch) {
            this.tablet = tablet;
            this.expectedBatch = expectedBatch;
        }

        public Deferred<BatchResponse> call(BatchResponse o) throws Exception {
            LOG.trace("Previous batch in flight is done, flushing this tablet again: " + Bytes.getString(this.tablet));
            return AsyncKuduSession.this.flushTablet(this.tablet, this.expectedBatch);
        }
    }

    final class TabletLookupCB<D>
    implements Callback<Deferred<OperationResponse>, D> {
        final Operation operation;

        TabletLookupCB(Operation operation) {
            this.operation = operation;
        }

        public Deferred<OperationResponse> call(D arg) {
            return AsyncKuduSession.this.handleOperationInLookup(this.operation);
        }

        public String toString() {
            return "retry RPC after lookup";
        }
    }

    class ConvertBatchToListOfResponsesCB
    implements Callback<Deferred<List<OperationResponse>>, ArrayList<BatchResponse>> {
        ConvertBatchToListOfResponsesCB() {
        }

        public Deferred<List<OperationResponse>> call(ArrayList<BatchResponse> batchResponsesList) throws Exception {
            Deferred deferred = new Deferred();
            if (batchResponsesList == null) {
                deferred.callback(null);
                return deferred;
            }
            batchResponsesList.removeAll(Collections.singleton(null));
            if (batchResponsesList.isEmpty()) {
                deferred.callback(null);
                return deferred;
            }
            int size = 0;
            for (BatchResponse batchResponse : batchResponsesList) {
                size += batchResponse.getIndividualResponses().size();
            }
            ArrayList<OperationResponse> responsesList = new ArrayList<OperationResponse>(size);
            for (BatchResponse batchResponse : batchResponsesList) {
                responsesList.addAll(batchResponse.getIndividualResponses());
            }
            deferred.callback(responsesList);
            return deferred;
        }
    }

    class OperationsInLookupDoneCB
    implements Callback<Deferred<ArrayList<BatchResponse>>, Void> {
        OperationsInLookupDoneCB() {
        }

        public Deferred<ArrayList<BatchResponse>> call(Void nothing) throws Exception {
            return AsyncKuduSession.this.flushAllBatches();
        }
    }
}

