/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.kududb.Common;
import org.kududb.Schema;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AlterTableOptions;
import org.kududb.client.AlterTableRequest;
import org.kududb.client.AlterTableResponse;
import org.kududb.client.AsyncKuduScanner;
import org.kududb.client.AsyncKuduSession;
import org.kududb.client.Bytes;
import org.kududb.client.CallResponse;
import org.kududb.client.CreateTableOptions;
import org.kududb.client.CreateTableRequest;
import org.kududb.client.CreateTableResponse;
import org.kududb.client.DeadlineTracker;
import org.kududb.client.DeleteTableRequest;
import org.kududb.client.DeleteTableResponse;
import org.kududb.client.ExternalConsistencyMode;
import org.kududb.client.GetMasterRegistrationReceived;
import org.kududb.client.GetMasterRegistrationRequest;
import org.kududb.client.GetMasterRegistrationResponse;
import org.kududb.client.GetTableLocationsRequest;
import org.kududb.client.GetTableSchemaRequest;
import org.kududb.client.GetTableSchemaResponse;
import org.kududb.client.IsAlterTableDoneRequest;
import org.kududb.client.IsAlterTableDoneResponse;
import org.kududb.client.IsCreateTableDoneRequest;
import org.kududb.client.KuduException;
import org.kududb.client.KuduRpc;
import org.kududb.client.KuduTable;
import org.kududb.client.ListTablesRequest;
import org.kududb.client.ListTablesResponse;
import org.kududb.client.ListTabletServersRequest;
import org.kududb.client.ListTabletServersResponse;
import org.kududb.client.LocatedTablet;
import org.kududb.client.NoLeaderMasterFoundException;
import org.kududb.client.NonRecoverableException;
import org.kududb.client.OperationResponse;
import org.kududb.client.Partition;
import org.kududb.client.ProtobufHelper;
import org.kududb.client.TabletClient;
import org.kududb.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.kududb.client.shaded.com.google.common.base.Objects;
import org.kududb.client.shaded.com.google.common.collect.ComparisonChain;
import org.kududb.client.shaded.com.google.common.collect.Lists;
import org.kududb.client.shaded.com.google.common.net.HostAndPort;
import org.kududb.client.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.kududb.client.shaded.com.google.protobuf.Message;
import org.kududb.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.kududb.client.shaded.org.jboss.netty.channel.DefaultChannelPipeline;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.SocketChannel;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.SocketChannelConfig;
import org.kududb.client.shaded.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.kududb.client.shaded.org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.kududb.client.shaded.org.jboss.netty.util.HashedWheelTimer;
import org.kududb.client.shaded.org.jboss.netty.util.Timeout;
import org.kududb.client.shaded.org.jboss.netty.util.TimerTask;
import org.kududb.consensus.Metadata;
import org.kududb.master.Master;
import org.kududb.util.AsyncUtil;
import org.kududb.util.NetUtil;
import org.kududb.util.Pair;
import org.kududb.util.Slice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AsyncKuduClient
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(AsyncKuduClient.class);
    public static final int SLEEP_TIME = 500;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final long NO_TIMESTAMP = -1L;
    public static final long DEFAULT_OPERATION_TIMEOUT_MS = 10000L;
    public static final long DEFAULT_SOCKET_READ_TIMEOUT_MS = 5000L;
    private final ClientSocketChannelFactory channelFactory;
    private final ConcurrentHashMap<String, ConcurrentSkipListMap<byte[], RemoteTablet>> tabletsCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Slice, RemoteTablet> tablet2client = new ConcurrentHashMap();
    private final ConcurrentHashMap<TabletClient, ArrayList<RemoteTablet>> client2tablets = new ConcurrentHashMap();
    private final HashMap<String, TabletClient> ip2client = new HashMap();
    @GuardedBy(value="sessions")
    private final Set<AsyncKuduSession> sessions = new HashSet<AsyncKuduSession>();
    static final String MASTER_TABLE_NAME_PLACEHOLDER = "Kudu Master";
    final KuduTable masterTable;
    private final List<HostAndPort> masterAddresses;
    private final HashedWheelTimer timer = new HashedWheelTimer(20L, TimeUnit.MILLISECONDS);
    private long lastPropagatedTimestamp = -1L;
    private final Set<String> tablesNotServed = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Semaphore masterLookups = new Semaphore(50);
    private final Random sleepRandomizer = new Random();
    private final long defaultOperationTimeoutMs;
    private final long defaultAdminOperationTimeoutMs;
    private final long defaultSocketReadTimeoutMs;
    private volatile boolean closed;

    private AsyncKuduClient(AsyncKuduClientBuilder b) {
        this.channelFactory = b.createChannelFactory();
        this.masterAddresses = b.masterAddresses;
        this.masterTable = new KuduTable(this, MASTER_TABLE_NAME_PLACEHOLDER, MASTER_TABLE_NAME_PLACEHOLDER, null, null);
        this.defaultOperationTimeoutMs = b.defaultOperationTimeoutMs;
        this.defaultAdminOperationTimeoutMs = b.defaultAdminOperationTimeoutMs;
        this.defaultSocketReadTimeoutMs = b.defaultSocketReadTimeoutMs;
    }

    @VisibleForTesting
    public synchronized void updateLastPropagatedTimestamp(long lastPropagatedTimestamp) {
        if (this.lastPropagatedTimestamp == -1L || this.lastPropagatedTimestamp < lastPropagatedTimestamp) {
            this.lastPropagatedTimestamp = lastPropagatedTimestamp;
        }
    }

    @VisibleForTesting
    public synchronized long getLastPropagatedTimestamp() {
        return this.lastPropagatedTimestamp;
    }

    public Deferred<KuduTable> createTable(String name, Schema schema) {
        return this.createTable(name, schema, new CreateTableOptions());
    }

    public Deferred<KuduTable> createTable(final String name, Schema schema, CreateTableOptions builder) {
        this.checkIsClosed();
        if (builder == null) {
            builder = new CreateTableOptions();
        }
        CreateTableRequest create = new CreateTableRequest(this.masterTable, name, schema, builder);
        create.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(create).addCallbackDeferring((Callback)new Callback<Deferred<KuduTable>, CreateTableResponse>(){

            public Deferred<KuduTable> call(CreateTableResponse createTableResponse) throws Exception {
                return AsyncKuduClient.this.openTable(name);
            }
        });
    }

    public Deferred<DeleteTableResponse> deleteTable(String name) {
        this.checkIsClosed();
        DeleteTableRequest delete = new DeleteTableRequest(this.masterTable, name);
        delete.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(delete);
    }

    public Deferred<AlterTableResponse> alterTable(String name, AlterTableOptions ato) {
        this.checkIsClosed();
        AlterTableRequest alter = new AlterTableRequest(this.masterTable, name, ato);
        alter.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(alter);
    }

    public Deferred<IsAlterTableDoneResponse> isAlterTableDone(String name) throws Exception {
        this.checkIsClosed();
        IsAlterTableDoneRequest request = new IsAlterTableDoneRequest(this.masterTable, name);
        request.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(request);
    }

    public Deferred<ListTabletServersResponse> listTabletServers() {
        this.checkIsClosed();
        ListTabletServersRequest rpc = new ListTabletServersRequest(this.masterTable);
        rpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(rpc);
    }

    Deferred<GetTableSchemaResponse> getTableSchema(String name) {
        GetTableSchemaRequest rpc = new GetTableSchemaRequest(this.masterTable, name);
        rpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(rpc);
    }

    public Deferred<ListTablesResponse> getTablesList() {
        return this.getTablesList(null);
    }

    public Deferred<ListTablesResponse> getTablesList(String nameFilter) {
        ListTablesRequest rpc = new ListTablesRequest(this.masterTable, nameFilter);
        rpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.sendRpcToTablet(rpc);
    }

    public Deferred<Boolean> tableExists(final String name) {
        if (name == null) {
            throw new IllegalArgumentException("The table name cannot be null");
        }
        return this.getTablesList().addCallbackDeferring((Callback)new Callback<Deferred<Boolean>, ListTablesResponse>(){

            public Deferred<Boolean> call(ListTablesResponse listTablesResponse) throws Exception {
                for (String tableName : listTablesResponse.getTablesList()) {
                    if (!name.equals(tableName)) continue;
                    return Deferred.fromResult((Object)true);
                }
                return Deferred.fromResult((Object)false);
            }
        });
    }

    public Deferred<KuduTable> openTable(final String name) {
        this.checkIsClosed();
        final KuduRpc<KuduTable> fakeRpc = new KuduRpc<KuduTable>(null){

            @Override
            ChannelBuffer serialize(Message header) {
                return null;
            }

            @Override
            String serviceName() {
                return null;
            }

            @Override
            String method() {
                return "IsCreateTableDone";
            }

            @Override
            Pair<KuduTable, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
                return null;
            }
        };
        fakeRpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        return this.getTableSchema(name).addCallbackDeferring((Callback)new Callback<Deferred<KuduTable>, GetTableSchemaResponse>(){

            public Deferred<KuduTable> call(GetTableSchemaResponse response) throws Exception {
                KuduTable table = new KuduTable(AsyncKuduClient.this, name, response.getTableId(), response.getSchema(), response.getPartitionSchema());
                Deferred d = fakeRpc.getDeferred();
                if (response.isCreateTableDone()) {
                    LOG.debug("Opened table {}", (Object)name);
                    fakeRpc.callback(table);
                } else {
                    LOG.debug("Delaying opening table {}, its tablets aren't fully created", (Object)name);
                    fakeRpc.attempt = (byte)(fakeRpc.attempt + 1);
                    AsyncKuduClient.this.delayedIsCreateTableDone(table, fakeRpc, AsyncKuduClient.this.getOpenTableCB(fakeRpc, table), AsyncKuduClient.this.getDelayedIsCreateTableDoneErrback(fakeRpc));
                }
                return d;
            }
        });
    }

    Callback<Deferred<KuduTable>, Master.IsCreateTableDoneResponsePB> getOpenTableCB(final KuduRpc<KuduTable> rpc, final KuduTable table) {
        return new Callback<Deferred<KuduTable>, Master.IsCreateTableDoneResponsePB>(){

            public Deferred<KuduTable> call(Master.IsCreateTableDoneResponsePB isCreateTableDoneResponsePB) throws Exception {
                String tableName = table.getName();
                Deferred d = rpc.getDeferred();
                if (isCreateTableDoneResponsePB.getDone()) {
                    LOG.debug("Table {}'s tablets are now created", (Object)tableName);
                    rpc.callback(table);
                } else {
                    rpc.attempt = (byte)(rpc.attempt + 1);
                    LOG.debug("Table {}'s tablets are still not created, further delaying opening it", (Object)tableName);
                    AsyncKuduClient.this.delayedIsCreateTableDone(table, rpc, AsyncKuduClient.this.getOpenTableCB(rpc, table), AsyncKuduClient.this.getDelayedIsCreateTableDoneErrback(rpc));
                }
                return d;
            }
        };
    }

    public long getDefaultOperationTimeoutMs() {
        return this.defaultOperationTimeoutMs;
    }

    public long getDefaultAdminOperationTimeoutMs() {
        return this.defaultAdminOperationTimeoutMs;
    }

    public long getDefaultSocketReadTimeoutMs() {
        return this.defaultSocketReadTimeoutMs;
    }

    public AsyncKuduScanner.AsyncKuduScannerBuilder newScannerBuilder(KuduTable table) {
        this.checkIsClosed();
        return new AsyncKuduScanner.AsyncKuduScannerBuilder(this, table);
    }

    Deferred<AsyncKuduScanner.Response> openScanner(final AsyncKuduScanner scanner) {
        return this.sendRpcToTablet(scanner.getOpenRequest()).addErrback((Callback)new Callback<Exception, Exception>(){

            public Exception call(Exception e) {
                String message = "Cannot openScanner because: ";
                LOG.warn(message, (Throwable)e);
                scanner.invalidate();
                return e;
            }

            public String toString() {
                return "openScanner errback";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncKuduSession newSession() {
        this.checkIsClosed();
        AsyncKuduSession session = new AsyncKuduSession(this);
        Set<AsyncKuduSession> set = this.sessions;
        synchronized (set) {
            this.sessions.add(session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(AsyncKuduSession session) {
        Set<AsyncKuduSession> set = this.sessions;
        synchronized (set) {
            boolean removed = this.sessions.remove(session);
            assert (removed);
        }
    }

    Deferred<AsyncKuduScanner.Response> scanNextRows(AsyncKuduScanner scanner) {
        RemoteTablet tablet = scanner.currentTablet();
        TabletClient client = this.clientFor(tablet);
        KuduRpc<AsyncKuduScanner.Response> next_request = scanner.getNextRowsRequest();
        Deferred<AsyncKuduScanner.Response> d = next_request.getDeferred();
        if (client == null) {
            return this.sendRpcToTablet(next_request);
        }
        next_request.attempt = (byte)(next_request.attempt + 1);
        client.sendRpc(next_request);
        return d;
    }

    Deferred<AsyncKuduScanner.Response> closeScanner(AsyncKuduScanner scanner) {
        RemoteTablet tablet = scanner.currentTablet();
        if (tablet == null) {
            return Deferred.fromResult(null);
        }
        TabletClient client = this.clientFor(tablet);
        if (client == null) {
            LOG.warn("Cannot close " + scanner + " properly, no connection open for " + (tablet == null ? null : tablet));
            return Deferred.fromResult(null);
        }
        KuduRpc<AsyncKuduScanner.Response> close_request = scanner.getCloseRequest();
        Deferred<AsyncKuduScanner.Response> d = close_request.getDeferred();
        close_request.attempt = (byte)(close_request.attempt + 1);
        client.sendRpc(close_request);
        return d;
    }

    <R> Deferred<R> sendRpcToTablet(KuduRpc<R> request) {
        TabletClient tabletClient;
        if (AsyncKuduClient.cannotRetryRequest(request)) {
            return AsyncKuduClient.tooManyAttemptsOrTimeout(request, null);
        }
        request.attempt = (byte)(request.attempt + 1);
        String tableId = request.getTable().getTableId();
        byte[] partitionKey = null;
        if (request instanceof KuduRpc.HasKey) {
            partitionKey = ((KuduRpc.HasKey)((Object)request)).partitionKey();
        }
        RemoteTablet tablet = this.getTablet(tableId, partitionKey);
        long lastPropagatedTs = this.getLastPropagatedTimestamp();
        if (request.getExternalConsistencyMode() == ExternalConsistencyMode.CLIENT_PROPAGATED && lastPropagatedTs != -1L) {
            request.setPropagatedTimestamp(lastPropagatedTs);
        }
        if (tablet != null && (tabletClient = this.clientFor(tablet)) != null) {
            request.setTablet(tablet);
            Deferred<R> d = request.getDeferred();
            tabletClient.sendRpc(request);
            return d;
        }
        if (this.tablesNotServed.contains(tableId)) {
            return this.delayedIsCreateTableDone(request.getTable(), request, new RetryRpcCB(request), this.getDelayedIsCreateTableDoneErrback(request));
        }
        RetryRpcCB cb = new RetryRpcCB(request);
        RetryRpcErrback<R> eb = new RetryRpcErrback<R>(request);
        Deferred<Master.GetTableLocationsResponsePB> returnedD = this.locateTablet(request.getTable(), partitionKey);
        return AsyncUtil.addCallbacksDeferring(returnedD, cb, eb);
    }

    <R> Callback<Exception, Exception> getDelayedIsCreateTableDoneErrback(final KuduRpc<R> request) {
        return new Callback<Exception, Exception>(){

            public Exception call(Exception e) throws Exception {
                request.errback(e);
                return e;
            }
        };
    }

    <R> Deferred<R> delayedIsCreateTableDone(final KuduTable table, KuduRpc<R> rpc, final Callback<Deferred<R>, Master.IsCreateTableDoneResponsePB> retryCB, final Callback<Exception, Exception> errback) {
        long sleepTime = this.getSleepTimeForRpc(rpc);
        if (rpc.deadlineTracker.wouldSleepingTimeout(sleepTime)) {
            return AsyncKuduClient.tooManyAttemptsOrTimeout(rpc, null);
        }
        final class RetryTimer
        implements TimerTask {
            RetryTimer() {
            }

            @Override
            public void run(Timeout timeout) {
                String tableId = table.getTableId();
                boolean has_permit = AsyncKuduClient.this.acquireMasterLookupPermit();
                if (!has_permit && !AsyncKuduClient.this.tablesNotServed.contains(tableId)) {
                    try {
                        retryCB.call(null);
                        return;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                IsCreateTableDoneRequest rpc = new IsCreateTableDoneRequest(AsyncKuduClient.this.masterTable, tableId);
                rpc.setTimeoutMillis(AsyncKuduClient.this.defaultAdminOperationTimeoutMs);
                Deferred d = AsyncKuduClient.this.sendRpcToTablet(rpc).addCallback((Callback)new IsCreateTableDoneCB(tableId));
                if (has_permit) {
                    d.addCallbacks(new ReleaseMasterLookupPermit(), new ReleaseMasterLookupPermit());
                }
                d.addCallbacks(retryCB, errback);
            }
        }
        this.newTimeout(new RetryTimer(), sleepTime);
        return rpc.getDeferred();
    }

    boolean isTableNotServed(String tableId) {
        return this.tablesNotServed.contains(tableId);
    }

    long getSleepTimeForRpc(KuduRpc<?> rpc) {
        byte attemptCount = rpc.attempt;
        assert (attemptCount > 0);
        if (attemptCount == 0) {
            LOG.warn("Possible bug: attempting to retry an RPC with no attempts. RPC: " + rpc, (Throwable)new Exception("Exception created to collect stack trace"));
            attemptCount = 1;
        }
        long sleepTime = attemptCount * 500 + this.sleepRandomizer.nextInt(50);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to sleep for " + sleepTime + " at retry " + rpc.attempt);
        }
        return sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<TabletClient> getTableClients() {
        HashMap<String, TabletClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            return new ArrayList<TabletClient>(this.ip2client.values());
        }
    }

    @VisibleForTesting
    void emptyTabletsCacheForTable(String tableId) {
        this.tabletsCache.remove(tableId);
        Set<Map.Entry<Slice, RemoteTablet>> tablets = this.tablet2client.entrySet();
        for (Map.Entry<Slice, RemoteTablet> entry : tablets) {
            if (!entry.getValue().getTableId().equals(tableId)) continue;
            tablets.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TabletClient clientFor(RemoteTablet tablet) {
        if (tablet == null) {
            return null;
        }
        ArrayList arrayList = tablet.tabletServers;
        synchronized (arrayList) {
            if (tablet.tabletServers.isEmpty()) {
                return null;
            }
            if (tablet.leaderIndex == -1) {
                return null;
            }
            return (TabletClient)tablet.tabletServers.get(tablet.leaderIndex);
        }
    }

    static boolean cannotRetryRequest(KuduRpc<?> rpc) {
        return rpc.deadlineTracker.timedOut() || rpc.attempt > 100;
    }

    static <R> Deferred<R> tooManyAttemptsOrTimeout(KuduRpc<R> request, KuduException cause) {
        String message = request.deadlineTracker.timedOut() ? "Time out: " : "Too many attempts: ";
        NonRecoverableException e = new NonRecoverableException(message + request, cause);
        request.errback(e);
        return Deferred.fromError((Exception)e);
    }

    Deferred<Master.GetTableLocationsResponsePB> locateTablet(KuduTable table, byte[] partitionKey) {
        RemoteTablet tablet;
        boolean has_permit = this.acquireMasterLookupPermit();
        String tableId = table.getTableId();
        if (!has_permit && (tablet = this.getTablet(tableId, partitionKey)) != null && this.clientFor(tablet) != null) {
            return Deferred.fromResult(null);
        }
        GetTableLocationsRequest rpc = new GetTableLocationsRequest(this.masterTable, partitionKey, partitionKey, tableId);
        rpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        Deferred<Master.GetTableLocationsResponsePB> d = this.isMasterTable(tableId) ? this.getMasterTableLocationsPB() : this.sendRpcToTablet(rpc);
        d.addCallback((Callback)new MasterLookupCB(table));
        if (has_permit) {
            d.addBoth(new ReleaseMasterLookupPermit());
        }
        return d;
    }

    Deferred<Master.GetTableLocationsResponsePB> getMasterTableLocationsPB() {
        Deferred responseD = new Deferred();
        GetMasterRegistrationReceived received = new GetMasterRegistrationReceived(this.masterAddresses, (Deferred<Master.GetTableLocationsResponsePB>)responseD);
        for (HostAndPort hostAndPort : this.masterAddresses) {
            Deferred d;
            TabletClient clientForHostAndPort = this.newMasterClient(hostAndPort);
            if (clientForHostAndPort == null) {
                String message = "Couldn't resolve this master's address " + hostAndPort.toString();
                LOG.warn(message);
                d = Deferred.fromError((Exception)new NonRecoverableException(message));
            } else {
                d = this.getMasterRegistration(clientForHostAndPort);
            }
            d.addCallbacks(received.callbackForNode(hostAndPort), received.errbackForNode(hostAndPort));
        }
        return responseD;
    }

    List<LocatedTablet> syncLocateTable(String tableId, byte[] startPartitionKey, byte[] endPartitionKey, long deadline) throws Exception {
        ArrayList<LocatedTablet> ret = Lists.newArrayList();
        byte[] lastEndPartitionKey = null;
        DeadlineTracker deadlineTracker = new DeadlineTracker();
        deadlineTracker.setDeadline(deadline);
        while (true) {
            if (deadlineTracker.timedOut()) {
                throw new NonRecoverableException("Took too long getting the list of tablets, deadline=" + deadline);
            }
            GetTableLocationsRequest rpc = new GetTableLocationsRequest(this.masterTable, startPartitionKey, endPartitionKey, tableId);
            rpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
            Deferred<Master.GetTableLocationsResponsePB> d = this.sendRpcToTablet(rpc);
            Master.GetTableLocationsResponsePB response = (Master.GetTableLocationsResponsePB)d.join(deadlineTracker.getMillisBeforeDeadline());
            if (response.getTabletLocationsCount() == 0) break;
            for (Master.TabletLocationsPB tabletPb : response.getTabletLocationsList()) {
                LocatedTablet locs = new LocatedTablet(tabletPb);
                ret.add(locs);
                Partition partition = locs.getPartition();
                if (lastEndPartitionKey != null && !partition.isEndPartition() && Bytes.memcmp(partition.getPartitionKeyEnd(), lastEndPartitionKey) < 0) {
                    throw new IllegalStateException("Server returned tablets out of order: end partition key '" + Bytes.pretty(partition.getPartitionKeyEnd()) + "' followed " + "end partition key '" + Bytes.pretty(lastEndPartitionKey) + "'");
                }
                lastEndPartitionKey = partition.getPartitionKeyEnd();
            }
            if (lastEndPartitionKey.length == 0 || endPartitionKey != null && Bytes.memcmp(lastEndPartitionKey, endPartitionKey) > 0) break;
            startPartitionKey = lastEndPartitionKey;
        }
        return ret;
    }

    <R> void handleTabletNotFound(KuduRpc<R> rpc, KuduException ex, TabletClient server) {
        this.invalidateTabletCache(rpc.getTablet(), server);
        this.handleRetryableError(rpc, ex);
    }

    <R> void handleNotLeader(KuduRpc<R> rpc, KuduException ex, TabletClient server) {
        rpc.getTablet().demoteLeader(server);
        this.handleRetryableError(rpc, ex);
    }

    <R> void handleRetryableError(KuduRpc<R> rpc, KuduException ex) {
        this.delayedSendRpcToTablet(rpc, ex);
    }

    private <R> void delayedSendRpcToTablet(final KuduRpc<R> rpc, KuduException ex) {
        long sleepTime = this.getSleepTimeForRpc(rpc);
        if (AsyncKuduClient.cannotRetryRequest(rpc) || rpc.deadlineTracker.wouldSleepingTimeout(sleepTime)) {
            AsyncKuduClient.tooManyAttemptsOrTimeout(rpc, ex);
            return;
        }
        final class RetryTimer
        implements TimerTask {
            RetryTimer() {
            }

            @Override
            public void run(Timeout timeout) {
                AsyncKuduClient.this.sendRpcToTablet(rpc);
            }
        }
        this.newTimeout(new RetryTimer(), sleepTime);
    }

    private void invalidateTabletCache(RemoteTablet tablet, TabletClient server) {
        LOG.info("Removing server " + server.getUuid() + " from this tablet's cache " + tablet.getTabletIdAsString());
        tablet.removeTabletServer(server);
    }

    boolean acquireMasterLookupPermit() {
        try {
            return this.masterLookups.tryAcquire(5L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void releaseMasterLookupPermit() {
        this.masterLookups.release();
    }

    @VisibleForTesting
    void discoverTablets(KuduTable table, Master.GetTableLocationsResponsePB response) throws NonRecoverableException {
        ConcurrentSkipListMap<byte[], RemoteTablet> oldTablets;
        String tableId = table.getTableId();
        String tableName = table.getName();
        if (response.getTabletLocationsCount() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Table {} has not been created yet", (Object)tableName);
            }
            this.tablesNotServed.add(tableId);
            return;
        }
        ConcurrentSkipListMap<byte[], RemoteTablet> tablets = this.tabletsCache.get(tableId);
        if (tablets == null && (oldTablets = this.tabletsCache.putIfAbsent(tableId, tablets = new ConcurrentSkipListMap(Bytes.MEMCMP))) != null) {
            tablets = oldTablets;
        }
        for (Master.TabletLocationsPB tabletPb : response.getTabletLocationsList()) {
            RemoteTablet rt = this.createTabletFromPb(tableId, tabletPb);
            Slice tabletId = rt.tabletId;
            RemoteTablet currentTablet = this.tablet2client.get(tabletId);
            if (currentTablet != null) {
                currentTablet.refreshServers(tabletPb);
                continue;
            }
            RemoteTablet oldRt = this.tablet2client.putIfAbsent(tabletId, rt);
            if (oldRt != null) continue;
            LOG.info("Discovered tablet {} for table {} with partition {}", new Object[]{tabletId.toString(Charset.defaultCharset()), tableName, rt.getPartition()});
            rt.refreshServers(tabletPb);
            tablets.put(rt.getPartition().getPartitionKeyStart(), rt);
        }
    }

    RemoteTablet createTabletFromPb(String tableId, Master.TabletLocationsPB tabletPb) {
        Partition partition = ProtobufHelper.pbToPartition(tabletPb.getPartition());
        Slice tabletId = new Slice(tabletPb.getTabletId().toByteArray());
        return new RemoteTablet(tableId, tabletId, partition);
    }

    RemoteTablet getTablet(String tableId, byte[] partitionKey) {
        ConcurrentSkipListMap<byte[], RemoteTablet> tablets = this.tabletsCache.get(tableId);
        if (tablets == null) {
            return null;
        }
        if (this.isMasterTable(tableId)) {
            if (tablets.firstEntry() == null) {
                return null;
            }
            return tablets.firstEntry().getValue();
        }
        Map.Entry<byte[], RemoteTablet> tabletPair = tablets.floorEntry(partitionKey);
        if (tabletPair == null) {
            return null;
        }
        Partition partition = tabletPair.getValue().getPartition();
        if (!partition.isEndPartition() && Bytes.memcmp(partitionKey, partition.getPartitionKeyEnd()) >= 0) {
            return null;
        }
        return tabletPair.getValue();
    }

    Deferred<GetMasterRegistrationResponse> getMasterRegistration(TabletClient masterClient) {
        GetMasterRegistrationRequest rpc = new GetMasterRegistrationRequest(this.masterTable);
        rpc.setTimeoutMillis(this.defaultAdminOperationTimeoutMs);
        Deferred d = rpc.getDeferred();
        rpc.attempt = (byte)(rpc.attempt + 1);
        masterClient.sendRpc(rpc);
        return d;
    }

    TabletClient newMasterClient(HostAndPort masterHostPort) {
        String ip = AsyncKuduClient.getIP(masterHostPort.getHostText());
        if (ip == null) {
            return null;
        }
        return this.newClient("Kudu Master - " + masterHostPort.toString(), ip, masterHostPort.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TabletClient newClient(String uuid, String host, int port) {
        SocketChannel chan;
        TabletClient client;
        String hostport = host + ':' + port;
        HashMap<String, TabletClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            client = this.ip2client.get(hostport);
            if (client != null && client.isAlive()) {
                return client;
            }
            TabletClientPipeline pipeline = new TabletClientPipeline();
            client = pipeline.init(uuid);
            chan = this.channelFactory.newChannel(pipeline);
            this.ip2client.put(hostport, client);
        }
        this.client2tablets.put(client, new ArrayList());
        SocketChannelConfig config = chan.getConfig();
        config.setConnectTimeoutMillis(5000);
        config.setTcpNoDelay(true);
        config.setKeepAlive(true);
        chan.connect(new InetSocketAddress(host, port));
        return client;
    }

    @Override
    public void close() throws Exception {
        this.shutdown().join(this.defaultAdminOperationTimeoutMs);
    }

    public Deferred<ArrayList<Void>> shutdown() {
        this.checkIsClosed();
        this.closed = true;
        final class DisconnectCB
        implements Callback<Deferred<ArrayList<Void>>, ArrayList<List<OperationResponse>>> {
            DisconnectCB() {
            }

            public Deferred<ArrayList<Void>> call(ArrayList<List<OperationResponse>> arg) {
                final class ReleaseResourcesCB
                implements Callback<ArrayList<Void>, ArrayList<Void>> {
                    ReleaseResourcesCB() {
                    }

                    public ArrayList<Void> call(ArrayList<Void> arg) {
                        LOG.debug("Releasing all remaining resources");
                        AsyncKuduClient.this.timer.stop();
                        final class ShutdownThread
                        extends Thread {
                            ShutdownThread() {
                                super("AsyncKuduClient@" + AsyncKuduClient.super.hashCode() + " shutdown");
                            }

                            @Override
                            public void run() {
                                AsyncKuduClient.this.channelFactory.releaseExternalResources();
                            }
                        }
                        new ShutdownThread().start();
                        return arg;
                    }

                    public String toString() {
                        return "release resources callback";
                    }
                }
                return AsyncKuduClient.this.disconnectEverything().addCallback((Callback)new ReleaseResourcesCB());
            }

            public String toString() {
                return "disconnect callback";
            }
        }
        return this.closeAllSessions().addBothDeferring((Callback)new DisconnectCB());
    }

    private void checkIsClosed() {
        if (this.closed) {
            throw new IllegalStateException("Cannot proceed, the client has already been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<ArrayList<List<OperationResponse>>> closeAllSessions() {
        HashSet<AsyncKuduSession> copyOfSessions;
        Set<AsyncKuduSession> set = this.sessions;
        synchronized (set) {
            copyOfSessions = new HashSet<AsyncKuduSession>(this.sessions);
        }
        if (this.sessions.isEmpty()) {
            return Deferred.fromResult(null);
        }
        ArrayList<Deferred<List<OperationResponse>>> deferreds = new ArrayList<Deferred<List<OperationResponse>>>(copyOfSessions.size());
        for (AsyncKuduSession session : copyOfSessions) {
            deferreds.add(session.close());
        }
        return Deferred.group(deferreds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<ArrayList<Void>> disconnectEverything() {
        HashMap<String, TabletClient> ip2client_copy;
        ArrayList<Deferred<Void>> deferreds = new ArrayList<Deferred<Void>>(2);
        HashMap<String, TabletClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            ip2client_copy = new HashMap<String, TabletClient>(this.ip2client);
        }
        for (TabletClient ts : ip2client_copy.values()) {
            deferreds.add(ts.shutdown());
        }
        final int size = deferreds.size();
        return Deferred.group(deferreds).addCallback((Callback)new Callback<ArrayList<Void>, ArrayList<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ArrayList<Void> call(ArrayList<Void> arg) {
                HashMap logme = null;
                HashMap hashMap = AsyncKuduClient.this.ip2client;
                synchronized (hashMap) {
                    if (!AsyncKuduClient.this.ip2client.isEmpty()) {
                        logme = new HashMap(AsyncKuduClient.this.ip2client);
                    }
                }
                if (logme != null) {
                    LOG.error("Some clients are left in the client cache and haven't been cleaned up: " + logme);
                }
                return arg;
            }

            public String toString() {
                return "wait " + size + " TabletClient.shutdown()";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress slowSearchClientIP(TabletClient client) {
        int port;
        String hostport = null;
        HashMap<String, TabletClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            for (Map.Entry<String, TabletClient> e : this.ip2client.entrySet()) {
                if (e.getValue() != client) continue;
                hostport = e.getKey();
                break;
            }
        }
        if (hostport == null) {
            HashMap<String, TabletClient> copy;
            HashMap<String, TabletClient> i$ = this.ip2client;
            synchronized (i$) {
                copy = new HashMap<String, TabletClient>(this.ip2client);
            }
            LOG.error("WTF?  Should never happen!  Couldn't find " + client + " in " + copy);
            return null;
        }
        int colon = hostport.indexOf(58, 1);
        if (colon < 1) {
            LOG.error("WTF?  Should never happen!  No `:' found in " + hostport);
            return null;
        }
        String host = AsyncKuduClient.getIP(hostport.substring(0, colon));
        if (host == null) {
            return null;
        }
        try {
            port = AsyncKuduClient.parsePortNumber(hostport.substring(colon + 1, hostport.length()));
        }
        catch (NumberFormatException e) {
            LOG.error("WTF?  Should never happen!  Bad port in " + hostport, (Throwable)e);
            return null;
        }
        return new InetSocketAddress(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientFromCache(TabletClient client, SocketAddress remote) {
        ArrayList<RemoteTablet> tablets;
        TabletClient old;
        Serializable addr;
        InetSocketAddress sock;
        if (remote == null) {
            return;
        }
        if (remote instanceof InetSocketAddress) {
            sock = (InetSocketAddress)remote;
            addr = sock.getAddress();
            if (addr == null) {
                LOG.error("WTF?  Unresolved IP for " + remote + ".  This shouldn't happen.");
                return;
            }
        } else {
            LOG.error("WTF?  Found a non-InetSocketAddress remote: " + remote + ".  This shouldn't happen.");
            return;
        }
        String hostport = addr.getHostAddress() + ':' + sock.getPort();
        addr = this.ip2client;
        synchronized (addr) {
            old = this.ip2client.remove(hostport);
        }
        LOG.debug("Removed from IP cache: {" + hostport + "} -> {" + client + "}");
        if (old == null) {
            LOG.trace("When expiring " + client + " from the client cache (host:port=" + hostport + "), it was found that there was no entry" + " corresponding to " + remote + ".  This shouldn't happen.");
        }
        if ((tablets = this.client2tablets.remove(client)) != null) {
            RemoteTablet[] tablets_copy;
            ArrayList<RemoteTablet> arrayList = tablets;
            synchronized (arrayList) {
                tablets_copy = tablets.toArray(new RemoteTablet[tablets.size()]);
                tablets = null;
            }
            for (RemoteTablet remoteTablet : tablets_copy) {
                remoteTablet.removeTabletServer(client);
            }
        }
    }

    private boolean isMasterTable(String tableId) {
        return MASTER_TABLE_NAME_PLACEHOLDER == tableId;
    }

    private static String getIP(String host) {
        long start = System.nanoTime();
        try {
            String ip = InetAddress.getByName(host).getHostAddress();
            long latency = System.nanoTime() - start;
            if (latency > 500000L && LOG.isDebugEnabled()) {
                LOG.debug("Resolved IP of `" + host + "' to " + ip + " in " + latency + "ns");
            } else if (latency >= 3000000L) {
                LOG.warn("Slow DNS lookup!  Resolved IP of `" + host + "' to " + ip + " in " + latency + "ns");
            }
            return ip;
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve the IP of `" + host + "' in " + (System.nanoTime() - start) + "ns");
            return null;
        }
    }

    private static int parsePortNumber(String portnum) throws NumberFormatException {
        int port = Integer.parseInt(portnum);
        if (port <= 0 || port > 65535) {
            throw new NumberFormatException(port == 0 ? "port is zero" : (port < 0 ? "port is negative: " : "port is too large: ") + port);
        }
        return port;
    }

    void newTimeout(TimerTask task, long timeout_ms) {
        try {
            this.timer.newTimeout(task, timeout_ms, TimeUnit.MILLISECONDS);
        }
        catch (IllegalStateException e) {
            LOG.warn("Failed to schedule timer.  Ignore this if we're shutting down.", (Throwable)e);
        }
    }

    public static final class AsyncKuduClientBuilder {
        private static final int DEFAULT_MASTER_PORT = 7051;
        private final List<HostAndPort> masterAddresses;
        private long defaultAdminOperationTimeoutMs = 10000L;
        private long defaultOperationTimeoutMs = 10000L;
        private long defaultSocketReadTimeoutMs = 5000L;
        private Executor bossExecutor;
        private Executor workerExecutor;

        public AsyncKuduClientBuilder(String masterAddresses) {
            this.masterAddresses = NetUtil.parseStrings(masterAddresses, 7051);
        }

        public AsyncKuduClientBuilder(List<String> masterAddresses) {
            this.masterAddresses = Lists.newArrayListWithCapacity(masterAddresses.size());
            for (String address : masterAddresses) {
                this.masterAddresses.add(NetUtil.parseString(address, 7051));
            }
        }

        public AsyncKuduClientBuilder defaultAdminOperationTimeoutMs(long timeoutMs) {
            this.defaultAdminOperationTimeoutMs = timeoutMs;
            return this;
        }

        public AsyncKuduClientBuilder defaultOperationTimeoutMs(long timeoutMs) {
            this.defaultOperationTimeoutMs = timeoutMs;
            return this;
        }

        public AsyncKuduClientBuilder defaultSocketReadTimeoutMs(long timeoutMs) {
            this.defaultSocketReadTimeoutMs = timeoutMs;
            return this;
        }

        public AsyncKuduClientBuilder nioExecutors(Executor bossExecutor, Executor workerExecutor) {
            this.bossExecutor = bossExecutor;
            this.workerExecutor = workerExecutor;
            return this;
        }

        private NioClientSocketChannelFactory createChannelFactory() {
            Executor boss = this.bossExecutor;
            Executor worker = this.workerExecutor;
            if (boss == null || worker == null) {
                ExecutorService defaultExec = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("kudu-nio-%d").setDaemon(true).build());
                if (boss == null) {
                    boss = defaultExec;
                }
                if (worker == null) {
                    worker = defaultExec;
                }
            }
            return new NioClientSocketChannelFactory(boss, worker);
        }

        public AsyncKuduClient build() {
            return new AsyncKuduClient(this);
        }
    }

    public class RemoteTablet
    implements Comparable<RemoteTablet> {
        private static final int NO_LEADER_INDEX = -1;
        private final String tableId;
        private final Slice tabletId;
        private final ArrayList<TabletClient> tabletServers = new ArrayList();
        private final Partition partition;
        private int leaderIndex = -1;

        RemoteTablet(String tableId, Slice tabletId, Partition partition) {
            this.tabletId = tabletId;
            this.tableId = tableId;
            this.partition = partition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshServers(Master.TabletLocationsPB tabletLocations) throws NonRecoverableException {
            ArrayList<TabletClient> arrayList = this.tabletServers;
            synchronized (arrayList) {
                this.tabletServers.clear();
                this.leaderIndex = -1;
                ArrayList<UnknownHostException> lookupExceptions = new ArrayList<UnknownHostException>(tabletLocations.getReplicasCount());
                for (Master.TabletLocationsPB.ReplicaPB replica : tabletLocations.getReplicasList()) {
                    List<Common.HostPortPB> addresses = replica.getTsInfo().getRpcAddressesList();
                    if (addresses.isEmpty()) {
                        LOG.warn("Tablet server for tablet " + this.getTabletIdAsString() + " doesn't have any " + "address");
                        continue;
                    }
                    byte[] buf = Bytes.get(replica.getTsInfo().getPermanentUuid());
                    String uuid = Bytes.getString(buf);
                    try {
                        this.addTabletClient(uuid, addresses.get(0).getHost(), addresses.get(0).getPort(), replica.getRole().equals(Metadata.RaftPeerPB.Role.LEADER));
                    }
                    catch (UnknownHostException ex) {
                        lookupExceptions.add(ex);
                    }
                }
                this.leaderIndex = 0;
                if (this.leaderIndex == -1) {
                    LOG.warn("No leader provided for tablet " + this.getTabletIdAsString());
                }
                if (!lookupExceptions.isEmpty() && lookupExceptions.size() == tabletLocations.getReplicasCount()) {
                    throw new NonRecoverableException("Couldn't find any valid locations, exceptions: " + lookupExceptions);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTabletClient(String uuid, String host, int port, boolean isLeader) throws UnknownHostException {
            String ip = AsyncKuduClient.getIP(host);
            if (ip == null) {
                throw new UnknownHostException("Failed to resolve the IP of `" + host + "'");
            }
            TabletClient client = AsyncKuduClient.this.newClient(uuid, ip, port);
            ArrayList tablets = (ArrayList)AsyncKuduClient.this.client2tablets.get(client);
            if (tablets == null) {
                this.addTabletClient(uuid, host, port, isLeader);
            } else {
                ArrayList arrayList = tablets;
                synchronized (arrayList) {
                    if (isLeader) {
                        this.tabletServers.add(0, client);
                    } else {
                        this.tabletServers.add(client);
                    }
                    tablets.add(this);
                }
            }
        }

        public String toString() {
            return this.getTabletIdAsString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeTabletServer(TabletClient ts) {
            ArrayList<TabletClient> arrayList = this.tabletServers;
            synchronized (arrayList) {
                int index = this.tabletServers.indexOf(ts);
                if (index == -1) {
                    return false;
                }
                this.tabletServers.remove(index);
                if (this.leaderIndex == index && this.leaderIndex == this.tabletServers.size()) {
                    this.leaderIndex = -1;
                } else if (this.leaderIndex > index) {
                    --this.leaderIndex;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void demoteLeader(TabletClient ts) {
            ArrayList<TabletClient> arrayList = this.tabletServers;
            synchronized (arrayList) {
                int index = this.tabletServers.indexOf(ts);
                if (index == -1 || this.leaderIndex == -1) {
                    return;
                }
                if (this.leaderIndex == index) {
                    this.leaderIndex = this.leaderIndex + 1 == this.tabletServers.size() ? -1 : ++this.leaderIndex;
                }
            }
        }

        public String getTableId() {
            return this.tableId;
        }

        Slice getTabletId() {
            return this.tabletId;
        }

        public Partition getPartition() {
            return this.partition;
        }

        byte[] getTabletIdAsBytes() {
            return this.tabletId.getBytes();
        }

        String getTabletIdAsString() {
            return this.tabletId.toString(Charset.defaultCharset());
        }

        List<Common.HostPortPB> getAddressesFromPb(Master.TabletLocationsPB tabletLocations) {
            ArrayList<Common.HostPortPB> addresses = new ArrayList<Common.HostPortPB>(tabletLocations.getReplicasCount());
            for (Master.TabletLocationsPB.ReplicaPB replica : tabletLocations.getReplicasList()) {
                addresses.add(replica.getTsInfo().getRpcAddresses(0));
            }
            return addresses;
        }

        @Override
        public int compareTo(RemoteTablet remoteTablet) {
            if (remoteTablet == null) {
                return 1;
            }
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.tableId), (Comparable<?>)((Object)remoteTablet.tableId)).compare(this.partition, remoteTablet.partition).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteTablet that = (RemoteTablet)o;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.tableId, this.partition);
        }
    }

    private final class TabletClientPipeline
    extends DefaultChannelPipeline {
        private final Logger log = LoggerFactory.getLogger(TabletClientPipeline.class);
        private boolean disconnected = false;

        private TabletClientPipeline() {
        }

        TabletClient init(String uuid) {
            TabletClient client = new TabletClient(AsyncKuduClient.this, uuid);
            if (AsyncKuduClient.this.defaultSocketReadTimeoutMs > 0L) {
                super.addLast("timeout-handler", new ReadTimeoutHandler(AsyncKuduClient.this.timer, AsyncKuduClient.this.defaultSocketReadTimeoutMs, TimeUnit.MILLISECONDS));
            }
            super.addLast("kudu-handler", client);
            return client;
        }

        @Override
        public void sendDownstream(ChannelEvent event) {
            if (event instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)event);
            }
            super.sendDownstream(event);
        }

        @Override
        public void sendUpstream(ChannelEvent event) {
            if (event instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)event);
            }
            super.sendUpstream(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDisconnect(ChannelStateEvent state_event) {
            if (this.disconnected) {
                return;
            }
            switch (state_event.getState()) {
                case OPEN: {
                    if (state_event.getValue() == Boolean.FALSE) break;
                    return;
                }
                case CONNECTED: {
                    if (state_event.getValue() == null) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.disconnected = true;
            try {
                TabletClient client = super.get(TabletClient.class);
                SocketAddress remote = super.getChannel().getRemoteAddress();
                if (remote == null) {
                    remote = AsyncKuduClient.this.slowSearchClientIP(client);
                }
                TabletClient tabletClient = client;
                synchronized (tabletClient) {
                    AsyncKuduClient.this.removeClientFromCache(client, remote);
                }
            }
            catch (Exception e) {
                this.log.error("Uncaught exception when handling a disconnection of " + this.getChannel(), (Throwable)e);
            }
        }
    }

    private final class MasterLookupCB
    implements Callback<Object, Master.GetTableLocationsResponsePB> {
        final KuduTable table;

        MasterLookupCB(KuduTable table) {
            this.table = table;
        }

        public Object call(Master.GetTableLocationsResponsePB arg) {
            try {
                AsyncKuduClient.this.discoverTablets(this.table, arg);
            }
            catch (NonRecoverableException e) {
                return e;
            }
            return null;
        }

        public String toString() {
            return "get tablet locations from the master for table " + this.table.getName();
        }
    }

    private final class IsCreateTableDoneCB
    implements Callback<Master.IsCreateTableDoneResponsePB, Master.IsCreateTableDoneResponsePB> {
        final String tableName;

        IsCreateTableDoneCB(String tableName) {
            this.tableName = tableName;
        }

        public Master.IsCreateTableDoneResponsePB call(Master.IsCreateTableDoneResponsePB response) {
            if (response.getDone()) {
                LOG.debug("Table {} was created", (Object)this.tableName);
                AsyncKuduClient.this.tablesNotServed.remove(this.tableName);
            } else {
                LOG.debug("Table {} is still being created", (Object)this.tableName);
            }
            return response;
        }

        public String toString() {
            return "ask the master if " + this.tableName + " was created";
        }
    }

    private final class ReleaseMasterLookupPermit<T>
    implements Callback<T, T> {
        private ReleaseMasterLookupPermit() {
        }

        public T call(T arg) {
            AsyncKuduClient.this.releaseMasterLookupPermit();
            return arg;
        }

        public String toString() {
            return "release master lookup permit";
        }
    }

    final class RetryRpcErrback<R>
    implements Callback<Deferred<R>, Exception> {
        private final KuduRpc<R> request;

        public RetryRpcErrback(KuduRpc<R> request) {
            this.request = request;
        }

        public Deferred<R> call(Exception arg) {
            if (arg instanceof NoLeaderMasterFoundException) {
                Deferred<R> d = this.request.getDeferred();
                AsyncKuduClient.this.delayedSendRpcToTablet(this.request, (NoLeaderMasterFoundException)arg);
                return d;
            }
            return Deferred.fromError((Exception)arg);
        }

        public String toString() {
            return "retry RPC after error";
        }
    }

    final class RetryRpcCB<R, D>
    implements Callback<Deferred<R>, D> {
        private final KuduRpc<R> request;

        RetryRpcCB(KuduRpc<R> request) {
            this.request = request;
        }

        public Deferred<R> call(D arg) {
            return AsyncKuduClient.this.sendRpcToTablet(this.request);
        }

        public String toString() {
            return "retry RPC";
        }
    }
}

