/*
 * Decompiled with CFR 0.152.
 */
package org.kududb.client;

import java.util.ArrayList;
import java.util.List;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;
import org.kududb.client.AsyncKuduClient;
import org.kududb.client.AsyncKuduScanner;
import org.kududb.client.Bytes;
import org.kududb.client.ColumnRangePredicate;
import org.kududb.client.KuduTable;
import org.kududb.client.PartialRow;
import org.kududb.client.shaded.com.google.common.collect.ImmutableList;
import org.kududb.tserver.Tserver;
import org.kududb.util.HybridTimeUtil;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractKuduScannerBuilder<S extends AbstractKuduScannerBuilder<? super S, T>, T> {
    final AsyncKuduClient client;
    final KuduTable table;
    final List<Tserver.ColumnRangePredicatePB> columnRangePredicates;
    AsyncKuduScanner.ReadMode readMode = AsyncKuduScanner.ReadMode.READ_LATEST;
    int batchSizeBytes = 0x100000;
    long limit = Long.MAX_VALUE;
    boolean prefetching = false;
    boolean cacheBlocks = true;
    long htTimestamp = -1L;
    byte[] lowerBoundPrimaryKey = AsyncKuduClient.EMPTY_ARRAY;
    byte[] upperBoundPrimaryKey = AsyncKuduClient.EMPTY_ARRAY;
    byte[] lowerBoundPartitionKey = AsyncKuduClient.EMPTY_ARRAY;
    byte[] upperBoundPartitionKey = AsyncKuduClient.EMPTY_ARRAY;
    List<String> projectedColumnNames = null;
    List<Integer> projectedColumnIndexes = null;
    long scanRequestTimeout;

    AbstractKuduScannerBuilder(AsyncKuduClient client, KuduTable table) {
        this.client = client;
        this.table = table;
        this.columnRangePredicates = new ArrayList<Tserver.ColumnRangePredicatePB>();
        this.scanRequestTimeout = client.getDefaultOperationTimeoutMs();
    }

    public S readMode(AsyncKuduScanner.ReadMode readMode) {
        this.readMode = readMode;
        return (S)this;
    }

    public S addColumnRangePredicate(ColumnRangePredicate predicate) {
        this.columnRangePredicates.add(predicate.getPb());
        return (S)this;
    }

    public S addColumnRangePredicatesRaw(byte[] predicateBytes) {
        List<Tserver.ColumnRangePredicatePB> predicates = ColumnRangePredicate.fromByteArray(predicateBytes);
        this.columnRangePredicates.addAll(predicates);
        return (S)this;
    }

    public S setProjectedColumnNames(List<String> columnNames) {
        this.projectedColumnIndexes = null;
        this.projectedColumnNames = columnNames != null ? ImmutableList.copyOf(columnNames) : null;
        return (S)this;
    }

    public S setProjectedColumnIndexes(List<Integer> columnIndexes) {
        this.projectedColumnNames = null;
        this.projectedColumnIndexes = columnIndexes != null ? ImmutableList.copyOf(columnIndexes) : null;
        return (S)this;
    }

    public S batchSizeBytes(int batchSizeBytes) {
        this.batchSizeBytes = batchSizeBytes;
        return (S)this;
    }

    public S limit(long limit) {
        this.limit = limit;
        return (S)this;
    }

    public S prefetching(boolean prefetching) {
        this.prefetching = prefetching;
        return (S)this;
    }

    public S cacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return (S)this;
    }

    @InterfaceAudience.Private
    public S snapshotTimestampRaw(long htTimestamp) {
        this.htTimestamp = htTimestamp;
        return (S)this;
    }

    public S snapshotTimestampMicros(long timestamp) {
        this.htTimestamp = HybridTimeUtil.physicalAndLogicalToHTTimestamp(timestamp, 0L);
        return (S)this;
    }

    public S scanRequestTimeout(long scanRequestTimeout) {
        this.scanRequestTimeout = scanRequestTimeout;
        return (S)this;
    }

    public S lowerBound(PartialRow partialRow) {
        return this.lowerBoundRaw(partialRow.encodePrimaryKey());
    }

    @Deprecated
    public S lowerBoundRaw(byte[] startPrimaryKey) {
        if (this.lowerBoundPrimaryKey == AsyncKuduClient.EMPTY_ARRAY || Bytes.memcmp(startPrimaryKey, this.lowerBoundPrimaryKey) > 0) {
            this.lowerBoundPrimaryKey = startPrimaryKey;
        }
        return (S)this;
    }

    public S exclusiveUpperBound(PartialRow partialRow) {
        return this.exclusiveUpperBoundRaw(partialRow.encodePrimaryKey());
    }

    @Deprecated
    public S exclusiveUpperBoundRaw(byte[] endPrimaryKey) {
        if (this.upperBoundPrimaryKey == AsyncKuduClient.EMPTY_ARRAY || Bytes.memcmp(endPrimaryKey, this.upperBoundPrimaryKey) < 0) {
            this.upperBoundPrimaryKey = endPrimaryKey;
        }
        return (S)this;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    public S lowerBoundPartitionKeyRaw(byte[] partitionKey) {
        if (Bytes.memcmp(partitionKey, this.lowerBoundPartitionKey) > 0) {
            this.lowerBoundPartitionKey = partitionKey;
        }
        return (S)this;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    public S exclusiveUpperBoundPartitionKeyRaw(byte[] partitionKey) {
        if (this.upperBoundPartitionKey.length == 0 || Bytes.memcmp(partitionKey, this.upperBoundPartitionKey) < 0) {
            this.upperBoundPartitionKey = partitionKey;
        }
        return (S)this;
    }

    public abstract T build();
}

