/*
 * Decompiled with CFR 0.152.
 */
package org.kududb;

import org.kududb.Common;
import org.kududb.Type;
import org.kududb.annotations.InterfaceAudience;
import org.kududb.annotations.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ColumnSchema {
    private final String name;
    private final Type type;
    private final boolean key;
    private final boolean nullable;
    private final Object defaultValue;
    private final int desiredBlockSize;
    private final Encoding encoding;
    private final CompressionAlgorithm compressionAlgorithm;

    private ColumnSchema(String name, Type type, boolean key, boolean nullable, Object defaultValue, int desiredBlockSize, Encoding encoding, CompressionAlgorithm compressionAlgorithm) {
        this.name = name;
        this.type = type;
        this.key = key;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.desiredBlockSize = desiredBlockSize;
        this.encoding = encoding;
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getDesiredBlockSize() {
        return this.desiredBlockSize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)o;
        if (this.key != that.key) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.key ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Column name: " + this.name + ", type: " + this.type.getName();
    }

    public static class ColumnSchemaBuilder {
        private final String name;
        private final Type type;
        private boolean key = false;
        private boolean nullable = false;
        private Object defaultValue = null;
        private int blockSize = 0;
        private Encoding encoding = null;
        private CompressionAlgorithm compressionAlgorithm = null;

        public ColumnSchemaBuilder(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public ColumnSchemaBuilder key(boolean key) {
            this.key = key;
            return this;
        }

        public ColumnSchemaBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public ColumnSchemaBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ColumnSchemaBuilder desiredBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public ColumnSchemaBuilder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public ColumnSchemaBuilder compressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public ColumnSchema build() {
            return new ColumnSchema(this.name, this.type, this.key, this.nullable, this.defaultValue, this.blockSize, this.encoding, this.compressionAlgorithm);
        }
    }

    public static enum CompressionAlgorithm {
        UNKNOWN(Common.CompressionType.UNKNOWN_COMPRESSION),
        DEFAULT_COMPRESSION(Common.CompressionType.DEFAULT_COMPRESSION),
        NO_COMPRESSION(Common.CompressionType.NO_COMPRESSION),
        SNAPPY(Common.CompressionType.SNAPPY),
        LZ4(Common.CompressionType.LZ4),
        ZLIB(Common.CompressionType.ZLIB);

        final Common.CompressionType internalPbType;

        private CompressionAlgorithm(Common.CompressionType internalPbType) {
            this.internalPbType = internalPbType;
        }

        @InterfaceAudience.Private
        public Common.CompressionType getInternalPbType() {
            return this.internalPbType;
        }
    }

    public static enum Encoding {
        UNKNOWN(Common.EncodingType.UNKNOWN_ENCODING),
        AUTO_ENCODING(Common.EncodingType.AUTO_ENCODING),
        PLAIN_ENCODING(Common.EncodingType.PLAIN_ENCODING),
        PREFIX_ENCODING(Common.EncodingType.PREFIX_ENCODING),
        GROUP_VARINT(Common.EncodingType.GROUP_VARINT),
        RLE(Common.EncodingType.RLE),
        DICT_ENCODING(Common.EncodingType.DICT_ENCODING),
        BIT_SHUFFLE(Common.EncodingType.BIT_SHUFFLE);

        final Common.EncodingType internalPbType;

        private Encoding(Common.EncodingType internalPbType) {
            this.internalPbType = internalPbType;
        }

        @InterfaceAudience.Private
        public Common.EncodingType getInternalPbType() {
            return this.internalPbType;
        }
    }
}

