/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.SQLException;
import java.util.List;
import oadd.net.hydromatic.avatica.AvaticaResultSetMetaData;
import oadd.net.hydromatic.avatica.AvaticaStatement;
import oadd.net.hydromatic.avatica.ColumnMetaData;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.InvalidParameterSqlException;

public class DrillResultSetMetaDataImpl
extends AvaticaResultSetMetaData {
    private final AvaticaStatement statement;

    public DrillResultSetMetaDataImpl(AvaticaStatement statement, Object query, List<ColumnMetaData> columnMetaDataList) {
        super(statement, query, columnMetaDataList);
        this.statement = statement;
    }

    private void throwIfClosed() throws AlreadyClosedSqlException, SQLException {
        if (this.statement.isClosed() || this.statement.getResultSet() != null && this.statement.getResultSet().isClosed()) {
            throw new AlreadyClosedSqlException("ResultSetMetaData's ResultSet is already closed.");
        }
    }

    private void throwIfClosedOrOutOfBounds(int columnNumber) throws InvalidParameterSqlException, SQLException {
        this.throwIfClosed();
        if (1 > columnNumber || columnNumber > this.getColumnCount()) {
            throw new InvalidParameterSqlException("Column number " + columnNumber + " out of range of from 1 through " + this.getColumnCount() + " (column count)");
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.throwIfClosed();
        return super.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isAutoIncrement(columnNumber);
    }

    @Override
    public boolean isCaseSensitive(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isCaseSensitive(columnNumber);
    }

    @Override
    public boolean isSearchable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isSearchable(columnNumber);
    }

    @Override
    public boolean isCurrency(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isCurrency(columnNumber);
    }

    @Override
    public int isNullable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isNullable(columnNumber);
    }

    @Override
    public boolean isSigned(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isSigned(columnNumber);
    }

    @Override
    public int getColumnDisplaySize(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnDisplaySize(columnNumber);
    }

    @Override
    public String getColumnLabel(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnLabel(columnNumber);
    }

    @Override
    public String getColumnName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnName(columnNumber);
    }

    @Override
    public String getSchemaName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getSchemaName(columnNumber);
    }

    @Override
    public int getPrecision(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getPrecision(columnNumber);
    }

    @Override
    public int getScale(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getScale(columnNumber);
    }

    @Override
    public String getTableName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getTableName(columnNumber);
    }

    @Override
    public String getCatalogName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getCatalogName(columnNumber);
    }

    @Override
    public int getColumnType(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnType(columnNumber);
    }

    @Override
    public String getColumnTypeName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnTypeName(columnNumber);
    }

    @Override
    public boolean isReadOnly(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isReadOnly(columnNumber);
    }

    @Override
    public boolean isWritable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isWritable(columnNumber);
    }

    @Override
    public boolean isDefinitelyWritable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isDefinitelyWritable(columnNumber);
    }

    @Override
    public String getColumnClassName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnClassName(columnNumber);
    }
}

