/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.jboss.netty.handler.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import oadd.org.jboss.netty.buffer.ChannelBuffer;
import oadd.org.jboss.netty.buffer.ChannelBuffers;
import oadd.org.jboss.netty.channel.Channel;
import oadd.org.jboss.netty.channel.ChannelDownstreamHandler;
import oadd.org.jboss.netty.channel.ChannelEvent;
import oadd.org.jboss.netty.channel.ChannelFuture;
import oadd.org.jboss.netty.channel.ChannelFutureListener;
import oadd.org.jboss.netty.channel.ChannelHandlerContext;
import oadd.org.jboss.netty.channel.ChannelStateEvent;
import oadd.org.jboss.netty.channel.Channels;
import oadd.org.jboss.netty.channel.DefaultChannelFuture;
import oadd.org.jboss.netty.channel.DownstreamMessageEvent;
import oadd.org.jboss.netty.channel.ExceptionEvent;
import oadd.org.jboss.netty.channel.MessageEvent;
import oadd.org.jboss.netty.handler.codec.frame.FrameDecoder;
import oadd.org.jboss.netty.handler.ssl.ImmediateExecutor;
import oadd.org.jboss.netty.handler.ssl.NotSslRecordException;
import oadd.org.jboss.netty.handler.ssl.SslBufferPool;
import oadd.org.jboss.netty.logging.InternalLogger;
import oadd.org.jboss.netty.logging.InternalLoggerFactory;
import oadd.org.jboss.netty.util.Timeout;
import oadd.org.jboss.netty.util.Timer;
import oadd.org.jboss.netty.util.TimerTask;
import oadd.org.jboss.netty.util.internal.DetectionUtil;
import oadd.org.jboss.netty.util.internal.NonReentrantLock;

public class SslHandler
extends FrameDecoder
implements ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static SslBufferPool defaultBufferPool;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslBufferPool bufferPool;
    private final Executor delegatedTaskExecutor;
    private final boolean startTls;
    private volatile boolean enableRenegotiation = true;
    final Object handshakeLock = new Object();
    private boolean handshaking;
    private volatile boolean handshaken;
    private volatile ChannelFuture handshakeFuture;
    private final AtomicBoolean sentFirstMessage = new AtomicBoolean();
    private final AtomicBoolean sentCloseNotify = new AtomicBoolean();
    int ignoreClosedChannelException;
    final Object ignoreClosedChannelExceptionLock = new Object();
    private final Queue<PendingWrite> pendingUnencryptedWrites = new LinkedList<PendingWrite>();
    private final NonReentrantLock pendingUnencryptedWritesLock = new NonReentrantLock();
    private final Queue<MessageEvent> pendingEncryptedWrites = new ConcurrentLinkedQueue<MessageEvent>();
    private final NonReentrantLock pendingEncryptedWritesLock = new NonReentrantLock();
    private volatile boolean issueHandshake;
    private final SSLEngineInboundCloseFuture sslEngineCloseFuture = new SSLEngineInboundCloseFuture();
    private boolean closeOnSSLException;
    private int packetLength = Integer.MIN_VALUE;
    private final Timer timer;
    private final long handshakeTimeoutInMillis;
    private Timeout handshakeTimeout;

    public static synchronized SslBufferPool getDefaultBufferPool() {
        if (defaultBufferPool == null) {
            defaultBufferPool = new SslBufferPool();
        }
        return defaultBufferPool;
    }

    public SslHandler(SSLEngine engine) {
        this(engine, SslHandler.getDefaultBufferPool(), (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool) {
        this(engine, bufferPool, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls) {
        this(engine, bufferPool, startTls, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, SslHandler.getDefaultBufferPool(), delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, Executor delegatedTaskExecutor) {
        this(engine, bufferPool, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls, Executor delegatedTaskExecutor) {
        this(engine, bufferPool, startTls, delegatedTaskExecutor, null, 0L);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls, Executor delegatedTaskExecutor, Timer timer, long handshakeTimeoutInMillis) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (bufferPool == null) {
            throw new NullPointerException("bufferPool");
        }
        if (delegatedTaskExecutor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        if (timer == null && handshakeTimeoutInMillis > 0L) {
            throw new IllegalArgumentException("No Timer was given but a handshakeTimeoutInMillis, need both or none");
        }
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.delegatedTaskExecutor = delegatedTaskExecutor;
        this.startTls = startTls;
        this.timer = timer;
        this.handshakeTimeoutInMillis = handshakeTimeoutInMillis;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture handshake() {
        Object object = this.handshakeLock;
        synchronized (object) {
            ChannelFuture handshakeFuture;
            if (this.handshaken && !this.isEnableRenegotiation()) {
                throw new IllegalStateException("renegotiation disabled");
            }
            final ChannelHandlerContext ctx = this.ctx;
            final Channel channel = ctx.getChannel();
            Exception exception = null;
            if (this.handshaking) {
                return this.handshakeFuture;
            }
            this.handshaking = true;
            try {
                this.engine.beginHandshake();
                this.runDelegatedTasks();
                handshakeFuture = this.handshakeFuture = Channels.future(channel);
                if (this.handshakeTimeoutInMillis > 0L) {
                    this.handshakeTimeout = this.timer.newTimeout(new TimerTask(){

                        public void run(Timeout timeout) throws Exception {
                            ChannelFuture future = SslHandler.this.handshakeFuture;
                            if (future != null && future.isDone()) {
                                return;
                            }
                            SslHandler.this.setHandshakeFailure(channel, new SSLException("Handshake did not complete within " + SslHandler.this.handshakeTimeoutInMillis + "ms"));
                        }
                    }, this.handshakeTimeoutInMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                handshakeFuture = this.handshakeFuture = Channels.failedFuture(channel, e);
                exception = e;
            }
            if (exception == null) {
                try {
                    final ChannelFuture hsFuture = handshakeFuture;
                    this.wrapNonAppData(ctx, channel).addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                Throwable cause = future.getCause();
                                hsFuture.setFailure(cause);
                                Channels.fireExceptionCaught(ctx, cause);
                                if (SslHandler.this.closeOnSSLException) {
                                    Channels.close(ctx, Channels.future(channel));
                                }
                            }
                        }
                    });
                }
                catch (SSLException e) {
                    handshakeFuture.setFailure(e);
                    Channels.fireExceptionCaught(ctx, (Throwable)e);
                    if (this.closeOnSSLException) {
                        Channels.close(ctx, Channels.future(channel));
                    }
                }
            } else {
                Channels.fireExceptionCaught(ctx, (Throwable)exception);
                if (this.closeOnSSLException) {
                    Channels.close(ctx, Channels.future(channel));
                }
            }
            return handshakeFuture;
        }
    }

    @Deprecated
    public ChannelFuture handshake(Channel channel) {
        return this.handshake();
    }

    public ChannelFuture close() {
        ChannelHandlerContext ctx = this.ctx;
        Channel channel = ctx.getChannel();
        try {
            this.engine.closeOutbound();
            return this.wrapNonAppData(ctx, channel);
        }
        catch (SSLException e) {
            Channels.fireExceptionCaught(ctx, (Throwable)e);
            if (this.closeOnSSLException) {
                Channels.close(ctx, Channels.future(channel));
            }
            return Channels.failedFuture(channel, e);
        }
    }

    @Deprecated
    public ChannelFuture close(Channel channel) {
        return this.close();
    }

    public boolean isEnableRenegotiation() {
        return this.enableRenegotiation;
    }

    public void setEnableRenegotiation(boolean enableRenegotiation) {
        this.enableRenegotiation = enableRenegotiation;
    }

    public void setIssueHandshake(boolean issueHandshake) {
        this.issueHandshake = issueHandshake;
    }

    public boolean isIssueHandshake() {
        return this.issueHandshake;
    }

    public ChannelFuture getSSLEngineInboundCloseFuture() {
        return this.sslEngineCloseFuture;
    }

    public long getHandshakeTimeout() {
        return this.handshakeTimeoutInMillis;
    }

    public void setCloseOnSSLException(boolean closeOnSslException) {
        if (this.ctx != null) {
            throw new IllegalStateException("Can only get changed before attached to ChannelPipeline");
        }
        this.closeOnSSLException = closeOnSslException;
    }

    public boolean getCloseOnSSLException() {
        return this.closeOnSSLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext context, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.closeOutboundAndChannel(context, (ChannelStateEvent)e);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            context.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        if (!(e.getMessage() instanceof ChannelBuffer)) {
            context.sendDownstream(evt);
            return;
        }
        if (this.startTls && this.sentFirstMessage.compareAndSet(false, true)) {
            context.sendDownstream(evt);
            return;
        }
        ChannelBuffer msg = (ChannelBuffer)e.getMessage();
        PendingWrite pendingWrite = msg.readable() ? new PendingWrite(evt.getFuture(), msg.toByteBuffer(msg.readerIndex(), msg.readableBytes())) : new PendingWrite(evt.getFuture(), null);
        this.pendingUnencryptedWritesLock.lock();
        try {
            this.pendingUnencryptedWrites.add(pendingWrite);
            Object var7_6 = null;
            this.pendingUnencryptedWritesLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.pendingUnencryptedWritesLock.unlock();
            throw throwable;
        }
        this.wrap(context, evt.getChannel());
    }

    private void cancelHandshakeTimeout() {
        if (this.handshakeTimeout != null) {
            this.handshakeTimeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                this.cancelHandshakeTimeout();
                this.handshakeFuture.setFailure(new ClosedChannelException());
            }
        }
        try {
            super.channelDisconnected(ctx, e);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_6 = null;
                this.unwrap(ctx, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
                this.engine.closeOutbound();
                if (!this.sentCloseNotify.get() && this.handshaken) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException ex) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug("Failed to clean up SSLEngine.", ex);
                    }
                }
            }
            throw throwable;
        }
        this.unwrap(ctx, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
        this.engine.closeOutbound();
        if (!this.sentCloseNotify.get() && this.handshaken) {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to clean up SSLEngine.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            if (cause instanceof ClosedChannelException) {
                Object object = this.ignoreClosedChannelExceptionLock;
                synchronized (object) {
                    if (this.ignoreClosedChannelException > 0) {
                        --this.ignoreClosedChannelException;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Swallowing an exception raised while writing non-app data", cause);
                        }
                        return;
                    }
                }
            } else if (this.ignoreException(cause)) {
                return;
            }
        }
        ctx.sendUpstream(e);
    }

    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.engine.isOutboundDone()) {
            StackTraceElement[] elements;
            String message = String.valueOf(t.getMessage()).toLowerCase();
            if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                return true;
            }
            for (StackTraceElement element : elements = t.getStackTrace()) {
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("oadd.org.jboss.netty.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (DetectionUtil.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ChannelBuffer buffer) {
        return SslHandler.getEncryptedPacketLength(buffer) != -1;
    }

    private static int getEncryptedPacketLength(ChannelBuffer buffer) {
        boolean tls;
        if (buffer.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        int packetLength = 0;
        switch (buffer.getUnsignedByte(buffer.readerIndex())) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                tls = true;
                break;
            }
            default: {
                tls = false;
            }
        }
        if (tls) {
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + 1);
            if (majorVersion == 3) {
                packetLength = (SslHandler.getShort(buffer, buffer.readerIndex() + 3) & 0xFFFF) + 5;
                if (packetLength <= 5) {
                    tls = false;
                }
            } else {
                tls = false;
            }
        }
        if (!tls) {
            boolean sslv2 = true;
            int headerLength = (buffer.getUnsignedByte(buffer.readerIndex()) & 0x80) != 0 ? 2 : 3;
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + headerLength + 1);
            if (majorVersion == 2 || majorVersion == 3) {
                packetLength = headerLength == 2 ? (SslHandler.getShort(buffer, buffer.readerIndex()) & Short.MAX_VALUE) + 2 : (SslHandler.getShort(buffer, buffer.readerIndex()) & 0x3FFF) + 3;
                if (packetLength <= headerLength) {
                    sslv2 = false;
                }
            } else {
                sslv2 = false;
            }
            if (!sslv2) {
                return -1;
            }
        }
        return packetLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.packetLength == Integer.MIN_VALUE) {
            if (buffer.readableBytes() < 5) {
                return null;
            }
            int packetLength = SslHandler.getEncryptedPacketLength(buffer);
            if (packetLength == -1) {
                NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ChannelBuffers.hexDump(buffer));
                buffer.skipBytes(buffer.readableBytes());
                if (this.closeOnSSLException) {
                    Channels.fireExceptionCaught(ctx, (Throwable)e);
                    Channels.close(ctx, Channels.future(channel));
                    return null;
                }
                throw e;
            }
            assert (packetLength > 0);
            this.packetLength = packetLength;
        }
        if (buffer.readableBytes() < this.packetLength) {
            return null;
        }
        int packetOffset = buffer.readerIndex();
        buffer.skipBytes(this.packetLength);
        try {
            ChannelBuffer channelBuffer = this.unwrap(ctx, channel, buffer, packetOffset, this.packetLength);
            Object var7_7 = null;
            this.packetLength = Integer.MIN_VALUE;
            return channelBuffer;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.packetLength = Integer.MIN_VALUE;
            throw throwable;
        }
    }

    private static short getShort(ChannelBuffer buf, int offset) {
        return (short)(buf.getByte(offset) << 8 | buf.getByte(offset + 1) & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void wrap(ChannelHandlerContext context, Channel channel) throws SSLException {
        outNetBuf = this.bufferPool.acquireBuffer();
        success = true;
        offered = false;
        needsUnwrap = false;
        pendingWrite = null;
        try {
            try {
                block23: while (true) {
                    this.pendingUnencryptedWritesLock.lock();
                    try {
                        pendingWrite = this.pendingUnencryptedWrites.peek();
                        if (pendingWrite == null) {
                            var17_18 = null;
                            this.pendingUnencryptedWritesLock.unlock();
                            break;
                        }
                        outAppBuf = pendingWrite.outAppBuf;
                        if (outAppBuf == null) {
                            this.pendingUnencryptedWrites.remove();
                            this.offerEncryptedWriteRequest(new DownstreamMessageEvent(channel, pendingWrite.future, ChannelBuffers.EMPTY_BUFFER, channel.getRemoteAddress()));
                            offered = true;
                        } else {
                            var9_10 = this.handshakeLock;
                            synchronized (var9_10) {
                                result = null;
                                try {
                                    result = this.engine.wrap(outAppBuf, outNetBuf);
                                    var12_15 = null;
                                    if (!outAppBuf.hasRemaining()) {
                                        this.pendingUnencryptedWrites.remove();
                                    }
                                }
                                catch (Throwable var11_12) {
                                    var12_15 = null;
                                    if (outAppBuf.hasRemaining() != false) throw var11_12;
                                    this.pendingUnencryptedWrites.remove();
                                    throw var11_12;
                                }
                                if (result.bytesProduced() > 0) {
                                    outNetBuf.flip();
                                    remaining = outNetBuf.remaining();
                                    msg = this.ctx.getChannel().getConfig().getBufferFactory().getBuffer(remaining);
                                    msg.writeBytes(outNetBuf);
                                    outNetBuf.clear();
                                    future = pendingWrite.outAppBuf.hasRemaining() != false ? Channels.succeededFuture(channel) : pendingWrite.future;
                                    encryptedWrite = new DownstreamMessageEvent(channel, future, msg, channel.getRemoteAddress());
                                    this.offerEncryptedWriteRequest(encryptedWrite);
                                    offered = true;
                                } else {
                                    if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                                        success = false;
                                        // MONITOREXIT @DISABLED, blocks:[0, 32, 1, 2, 38, 23, 10, 31] lbl58 : MonitorExitStatement: MONITOREXIT : var9_10
                                        var17_18 = null;
                                        this.pendingUnencryptedWritesLock.unlock();
                                        break;
                                    }
                                    handshakeStatus = result.getHandshakeStatus();
                                    this.handleRenegotiation(handshakeStatus);
                                    switch (7.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[handshakeStatus.ordinal()]) {
                                        case 1: {
                                            if (outAppBuf.hasRemaining()) break;
                                            // MONITOREXIT @DISABLED, blocks:[0, 32, 1, 2, 38, 23, 10, 11, 12] lbl68 : MonitorExitStatement: MONITOREXIT : var9_10
                                            var17_18 = null;
                                            this.pendingUnencryptedWritesLock.unlock();
                                            break block23;
                                        }
                                        case 2: {
                                            needsUnwrap = true;
                                            // MONITOREXIT @DISABLED, blocks:[0, 32, 1, 2, 38, 23, 10, 11, 13] lbl75 : MonitorExitStatement: MONITOREXIT : var9_10
                                            var17_18 = null;
                                            this.pendingUnencryptedWritesLock.unlock();
                                            break block23;
                                        }
                                        case 3: {
                                            this.runDelegatedTasks();
                                            break;
                                        }
                                        case 4: 
                                        case 5: {
                                            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                                                this.setHandshakeSuccess(channel);
                                            }
                                            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                                                success = false;
                                            }
                                            // MONITOREXIT @DISABLED, blocks:[0, 32, 1, 2, 38, 23, 10, 11, 15] lbl88 : MonitorExitStatement: MONITOREXIT : var9_10
                                            var17_18 = null;
                                            this.pendingUnencryptedWritesLock.unlock();
                                            break block23;
                                        }
                                        default: {
                                            throw new IllegalStateException("Unknown handshake status: " + (Object)handshakeStatus);
                                        }
                                    }
                                }
                            }
                        }
                        var17_18 = null;
                        this.pendingUnencryptedWritesLock.unlock();
                    }
                    catch (Throwable var16_19) {
                        var17_18 = null;
                        this.pendingUnencryptedWritesLock.unlock();
                        throw var16_19;
                    }
                }
                var19_20 = null;
                this.bufferPool.releaseBuffer(outNetBuf);
                if (offered) {
                    this.flushPendingEncryptedWrites(context);
                }
                if (success) ** GOTO lbl144
                cause = new IllegalStateException("SSLEngine already closed");
                if (pendingWrite == null) ** GOTO lbl130
                pendingWrite.future.setFailure(cause);
            }
            catch (SSLException e) {
                success = false;
                this.setHandshakeFailure(channel, e);
                throw e;
            }
            ** GOTO lbl130
        }
        catch (Throwable var18_28) {
            block40: {
                var19_21 = null;
                this.bufferPool.releaseBuffer(outNetBuf);
                if (offered) {
                    this.flushPendingEncryptedWrites(context);
                }
                if (success != false) throw var18_28;
                cause = new IllegalStateException("SSLEngine already closed");
                if (pendingWrite != null) {
                    pendingWrite.future.setFailure(cause);
                }
                break block40;
lbl130:
                // 2 sources

                while (true) {
                    this.pendingUnencryptedWritesLock.lock();
                    pendingWrite = this.pendingUnencryptedWrites.poll();
                    if (pendingWrite == null) {
                        var22_24 = null;
                        this.pendingUnencryptedWritesLock.unlock();
                        break;
                    }
                    var22_24 = null;
                    this.pendingUnencryptedWritesLock.unlock();
                    pendingWrite.future.setFailure(cause);
                }
lbl144:
                // 2 sources

                if (needsUnwrap == false) return;
                this.unwrap(context, channel, ChannelBuffers.EMPTY_BUFFER, 0, 0);
                return;
                catch (Throwable var21_26) {
                    var22_24 = null;
                    this.pendingUnencryptedWritesLock.unlock();
                    throw var21_26;
                }
            }
            while (true) {
                this.pendingUnencryptedWritesLock.lock();
                try {}
                catch (Throwable var21_27) {
                    var22_25 = null;
                    this.pendingUnencryptedWritesLock.unlock();
                    throw var21_27;
                }
                pendingWrite = this.pendingUnencryptedWrites.poll();
                if (pendingWrite == null) {
                    var22_25 = null;
                    this.pendingUnencryptedWritesLock.unlock();
                    throw var18_28;
                }
                var22_25 = null;
                this.pendingUnencryptedWritesLock.unlock();
                pendingWrite.future.setFailure(cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEncryptedWriteRequest(MessageEvent encryptedWrite) {
        boolean locked = this.pendingEncryptedWritesLock.tryLock();
        try {
            this.pendingEncryptedWrites.add(encryptedWrite);
            Object var4_3 = null;
            if (locked) {
                this.pendingEncryptedWritesLock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (locked) {
                this.pendingEncryptedWritesLock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingEncryptedWrites(ChannelHandlerContext ctx) {
        while (!this.pendingEncryptedWrites.isEmpty()) {
            Object var4_3;
            if (!this.pendingEncryptedWritesLock.tryLock()) {
                return;
            }
            try {
                MessageEvent e;
                while ((e = this.pendingEncryptedWrites.poll()) != null) {
                    ctx.sendDownstream(e);
                }
                var4_3 = null;
                this.pendingEncryptedWritesLock.unlock();
            }
            catch (Throwable throwable) {
                var4_3 = null;
                this.pendingEncryptedWritesLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture wrapNonAppData(ChannelHandlerContext ctx, Channel channel) throws SSLException {
        ChannelFuture future = null;
        ByteBuffer outNetBuf = this.bufferPool.acquireBuffer();
        try {
            try {
                SSLEngineResult result;
                block13: do {
                    Object object = this.handshakeLock;
                    synchronized (object) {
                        result = this.engine.wrap(EMPTY_BUFFER, outNetBuf);
                    }
                    if (result.bytesProduced() > 0) {
                        outNetBuf.flip();
                        ChannelBuffer msg = ctx.getChannel().getConfig().getBufferFactory().getBuffer(outNetBuf.remaining());
                        msg.writeBytes(outNetBuf);
                        outNetBuf.clear();
                        future = Channels.future(channel);
                        future.addListener(new ChannelFutureListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.getCause() instanceof ClosedChannelException) {
                                    Object object = SslHandler.this.ignoreClosedChannelExceptionLock;
                                    synchronized (object) {
                                        ++SslHandler.this.ignoreClosedChannelException;
                                    }
                                }
                            }
                        });
                        Channels.write(ctx, future, msg);
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    this.handleRenegotiation(handshakeStatus);
                    switch (handshakeStatus) {
                        case FINISHED: {
                            this.setHandshakeSuccess(channel);
                            this.runDelegatedTasks();
                            break;
                        }
                        case NEED_TASK: {
                            this.runDelegatedTasks();
                            break;
                        }
                        case NEED_UNWRAP: {
                            if (Thread.holdsLock(this.handshakeLock)) continue block13;
                            this.unwrap(ctx, channel, ChannelBuffers.EMPTY_BUFFER, 0, 0);
                            break;
                        }
                        case NEED_WRAP: 
                        case NOT_HANDSHAKING: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected handshake status: " + (Object)((Object)handshakeStatus));
                        }
                    }
                } while (result.bytesProduced() != 0);
                Object var9_9 = null;
                this.bufferPool.releaseBuffer(outNetBuf);
            }
            catch (SSLException e) {
                this.setHandshakeFailure(channel, e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.bufferPool.releaseBuffer(outNetBuf);
            throw throwable;
        }
        if (future == null) {
            future = Channels.succeededFuture(channel);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuffer unwrap(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, int offset, int length) throws SSLException {
        ByteBuffer outAppBuf;
        block26: {
            ByteBuffer inNetBuf = buffer.toByteBuffer(offset, length);
            outAppBuf = this.bufferPool.acquireBuffer();
            boolean needsWrap = false;
            block22: while (true) {
                boolean needsHandshake = false;
                Object object = this.handshakeLock;
                synchronized (object) {
                    if (!(this.handshaken || this.handshaking || this.engine.getUseClientMode() || this.engine.isInboundDone() || this.engine.isOutboundDone())) {
                        needsHandshake = true;
                    }
                }
                if (needsHandshake) {
                    this.handshake();
                }
                object = this.handshakeLock;
                synchronized (object) {
                    SSLEngineResult result = this.engine.unwrap(inNetBuf, outAppBuf);
                    switch (result.getStatus()) {
                        case CLOSED: {
                            this.sslEngineCloseFuture.setClosed();
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            throw new SSLException("SSLEngine.unwrap() reported an impossible buffer overflow.");
                        }
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    this.handleRenegotiation(handshakeStatus);
                    switch (handshakeStatus) {
                        case NEED_UNWRAP: {
                            if (inNetBuf.hasRemaining() && !this.engine.isInboundDone()) break;
                            break block22;
                        }
                        case NEED_WRAP: {
                            this.wrapNonAppData(ctx, channel);
                            break;
                        }
                        case NEED_TASK: {
                            this.runDelegatedTasks();
                            break;
                        }
                        case FINISHED: {
                            this.setHandshakeSuccess(channel);
                            needsWrap = true;
                            break block22;
                        }
                        case NOT_HANDSHAKING: {
                            needsWrap = true;
                            break block22;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)handshakeStatus));
                        }
                    }
                }
            }
            if (needsWrap && !Thread.holdsLock(this.handshakeLock) && !this.pendingEncryptedWritesLock.isHeldByCurrentThread()) {
                this.wrap(ctx, channel);
            }
            outAppBuf.flip();
            if (!outAppBuf.hasRemaining()) break block26;
            ChannelBuffer frame = ctx.getChannel().getConfig().getBufferFactory().getBuffer(outAppBuf.remaining());
            frame.writeBytes(outAppBuf);
            ChannelBuffer channelBuffer = frame;
            Object var15_17 = null;
            this.bufferPool.releaseBuffer(outAppBuf);
            return channelBuffer;
        }
        try {
            ChannelBuffer channelBuffer = null;
            Object var15_18 = null;
            this.bufferPool.releaseBuffer(outAppBuf);
            return channelBuffer;
        }
        catch (SSLException e) {
            try {
                this.setHandshakeFailure(channel, e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                this.bufferPool.releaseBuffer(outAppBuf);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRenegotiation(SSLEngineResult.HandshakeStatus handshakeStatus) {
        Object object = this.handshakeLock;
        synchronized (object) {
            boolean renegotiate;
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                return;
            }
            if (!this.handshaken) {
                return;
            }
            if (this.handshaking) {
                return;
            }
            if (this.engine.isInboundDone() || this.engine.isOutboundDone()) {
                return;
            }
            if (this.isEnableRenegotiation()) {
                renegotiate = true;
            } else {
                renegotiate = false;
                this.handshaking = true;
            }
            if (renegotiate) {
                this.handshake();
            } else {
                Channels.fireExceptionCaught(this.ctx, (Throwable)new SSLException("renegotiation attempted by peer; closing the connection"));
                Channels.close(this.ctx, Channels.succeededFuture(this.ctx.getChannel()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelegatedTasks() {
        while (true) {
            Runnable task;
            Object object = this.handshakeLock;
            synchronized (object) {
                task = this.engine.getDelegatedTask();
            }
            if (task == null) break;
            this.delegatedTaskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SslHandler.this.handshakeLock;
                    synchronized (object) {
                        task.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeSuccess(Channel channel) {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.handshaking = false;
            this.handshaken = true;
            if (this.handshakeFuture == null) {
                this.handshakeFuture = Channels.future(channel);
            }
            this.cancelHandshakeTimeout();
        }
        this.handshakeFuture.setSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(Channel channel, SSLException cause) {
        Object object = this.handshakeLock;
        synchronized (object) {
            block8: {
                if (!this.handshaking) {
                    return;
                }
                this.handshaking = false;
                this.handshaken = false;
                if (this.handshakeFuture == null) {
                    this.handshakeFuture = Channels.future(channel);
                }
                this.cancelHandshakeTimeout();
                this.engine.closeOutbound();
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("SSLEngine.closeInbound() raised an exception after a handshake failure.", e);
                }
            }
        }
        this.handshakeFuture.setFailure(cause);
        if (this.closeOnSSLException) {
            Channels.close(this.ctx, Channels.future(channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundAndChannel(ChannelHandlerContext context, ChannelStateEvent e) {
        if (!e.getChannel().isConnected()) {
            context.sendDownstream(e);
            return;
        }
        boolean passthrough = true;
        try {
            block11: {
                block10: {
                    try {
                        this.unwrap(context, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
                    }
                    catch (SSLException ex) {
                        if (!logger.isDebugEnabled()) break block10;
                        logger.debug("Failed to unwrap before sending a close_notify message", ex);
                    }
                }
                if (!this.engine.isOutboundDone() && this.sentCloseNotify.compareAndSet(false, true)) {
                    this.engine.closeOutbound();
                    try {
                        ChannelFuture closeNotifyFuture = this.wrapNonAppData(context, e.getChannel());
                        closeNotifyFuture.addListener(new ClosingChannelFutureListener(context, e));
                        passthrough = false;
                    }
                    catch (SSLException ex) {
                        if (!logger.isDebugEnabled()) break block11;
                        logger.debug("Failed to encode a close_notify message", ex);
                    }
                }
            }
            Object var6_7 = null;
            if (passthrough) {
                context.sendDownstream(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (passthrough) {
                context.sendDownstream(e);
            }
            throw throwable;
        }
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        super.beforeAdd(ctx);
        this.ctx = ctx;
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        MessageEvent ev;
        PendingWrite pw;
        IOException cause = null;
        while ((pw = this.pendingUnencryptedWrites.poll()) != null) {
            if (cause == null) {
                cause = new IOException("Unable to write data");
            }
            pw.future.setFailure(cause);
        }
        while ((ev = this.pendingEncryptedWrites.poll()) != null) {
            if (cause == null) {
                cause = new IOException("Unable to write data");
            }
            ev.getFuture().setFailure(cause);
        }
        if (cause != null) {
            Channels.fireExceptionCaughtLater(ctx, (Throwable)cause);
        }
    }

    public void channelConnected(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        if (this.issueHandshake) {
            this.handshake().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ctx.sendUpstream(e);
                    }
                }
            });
        } else {
            super.channelConnected(ctx, e);
        }
    }

    public void channelClosed(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.getPipeline().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!SslHandler.this.pendingUnencryptedWritesLock.tryLock()) {
                    return;
                }
                ClosedChannelException cause = null;
                try {
                    MessageEvent ev;
                    PendingWrite pw;
                    while ((pw = (PendingWrite)SslHandler.this.pendingUnencryptedWrites.poll()) != null) {
                        if (cause == null) {
                            cause = new ClosedChannelException();
                        }
                        pw.future.setFailure(cause);
                    }
                    while ((ev = (MessageEvent)SslHandler.this.pendingEncryptedWrites.poll()) != null) {
                        if (cause == null) {
                            cause = new ClosedChannelException();
                        }
                        ev.getFuture().setFailure(cause);
                    }
                    Object var4_3 = null;
                    SslHandler.this.pendingUnencryptedWritesLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    SslHandler.this.pendingUnencryptedWritesLock.unlock();
                    throw throwable;
                }
                if (cause != null) {
                    Channels.fireExceptionCaught(ctx, (Throwable)cause);
                }
            }
        });
        super.channelClosed(ctx, e);
    }

    private final class SSLEngineInboundCloseFuture
    extends DefaultChannelFuture {
        public SSLEngineInboundCloseFuture() {
            super(null, true);
        }

        void setClosed() {
            super.setSuccess();
        }

        public Channel getChannel() {
            if (SslHandler.this.ctx == null) {
                return null;
            }
            return SslHandler.this.ctx.getChannel();
        }

        public boolean setSuccess() {
            return false;
        }

        public boolean setFailure(Throwable cause) {
            return false;
        }
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext context;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext context, ChannelStateEvent e) {
            this.context = context;
            this.e = e;
        }

        public void operationComplete(ChannelFuture closeNotifyFuture) throws Exception {
            if (!(closeNotifyFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.context, this.e.getFuture());
            } else {
                this.e.getFuture().setSuccess();
            }
        }
    }

    private static final class PendingWrite {
        final ChannelFuture future;
        final ByteBuffer outAppBuf;

        PendingWrite(ChannelFuture future, ByteBuffer outAppBuf) {
            this.future = future;
            this.outAppBuf = outAppBuf;
        }
    }
}

